--
-- PostgreSQL database dump
--

-- Started on 2009-01-07 16:59:03

DROP PROCEDURAL LANGUAGE IF EXISTS plpgsql; 
CREATE PROCEDURAL LANGUAGE plpgsql;

--
-- TOC entry 18 (class 1255 OID 239011)
-- Dependencies: 5 272

-- Name: update_created_column(); Type: FUNCTION; Schema: public; Owner: crm_user
--

CREATE FUNCTION update_created_column() RETURNS "trigger"
    AS 'BEGIN NEW.date_created = now(); RETURN NEW; END;'
    LANGUAGE plpgsql;


ALTER FUNCTION public.update_created_column() OWNER TO crm_user;

--
-- TOC entry 1645 (class 0 OID 0)
-- Dependencies: 18
-- Name: FUNCTION update_created_column(); Type: COMMENT; Schema: public; Owner: crm_user
--

COMMENT ON FUNCTION update_created_column() IS 'Sets date_created to the current date. Should be triggered on  Inserts.';


--
-- TOC entry 19 (class 1255 OID 239012)
-- Dependencies: 5 272
-- Name: update_modified_column(); Type: FUNCTION; Schema: public; Owner: crm_user
--

CREATE FUNCTION update_modified_column() RETURNS "trigger"
    AS 'BEGIN NEW.last_modified = now(); RETURN NEW; END;'
    LANGUAGE plpgsql;


ALTER FUNCTION public.update_modified_column() OWNER TO crm_user;

--
-- TOC entry 1646 (class 0 OID 0)
-- Dependencies: 19
-- Name: FUNCTION update_modified_column(); Type: COMMENT; Schema: public; Owner: crm_user
--

COMMENT ON FUNCTION update_modified_column() IS 'Sets last_modified to the current date. Should be triggered on Updates.';


--
-- TOC entry 1277 (class 1259 OID 239013)
-- Dependencies: 5
-- Name: country; Type: TABLE; Schema: public; Owner: crm_user; Tablespace: 
--

CREATE TABLE country (
    date_created timestamp without time zone NOT NULL,
    last_modified timestamp without time zone NOT NULL,
    name character varying(2000) NOT NULL,
    iso_code character varying(2) NOT NULL,
    country_id character varying(255) NOT NULL
);


ALTER TABLE public.country OWNER TO crm_user;

--
-- TOC entry 1647 (class 0 OID 0)
-- Dependencies: 1277
-- Name: COLUMN country.date_created; Type: COMMENT; Schema: public; Owner: crm_user
--

COMMENT ON COLUMN country.date_created IS 'is automatically set on each row when it is inserted';


--
-- TOC entry 1648 (class 0 OID 0)
-- Dependencies: 1277
-- Name: COLUMN country.last_modified; Type: COMMENT; Schema: public; Owner: crm_user
--

COMMENT ON COLUMN country.last_modified IS 'is automatically set on each row when it changes';


--
-- TOC entry 1649 (class 0 OID 0)
-- Dependencies: 1277
-- Name: COLUMN country.name; Type: COMMENT; Schema: public; Owner: crm_user
--

COMMENT ON COLUMN country.name IS 'English name of the Country, e.g. Germany, according to ISO 3166-1 alpha-2';


--
-- TOC entry 1650 (class 0 OID 0)
-- Dependencies: 1277
-- Name: COLUMN country.iso_code; Type: COMMENT; Schema: public; Owner: crm_user
--

COMMENT ON COLUMN country.iso_code IS 'ISO 3166-1-alpha-2 code http://www.iso.org/iso/country_codes/iso_3166_code_lists/english_country_names_and_code_elements.htm';


--
-- TOC entry 1278 (class 1259 OID 239018)
-- Dependencies: 1612 5
-- Name: customer; Type: TABLE; Schema: public; Owner: crm_user; Tablespace: 
--

CREATE TABLE customer (
    name character varying(300) NOT NULL,
    customer_number character varying(50),
    delivery_address_field2 character varying(500),
    delivery_address_field3 character varying(500),
    delivery_address_field1 character varying(500),
    delivery_address_street character varying(255),
    delivery_address_street_number character varying(10),
    delivery_address_zip_code character varying(255),
    delivery_address_city character varying(255),
    delivery_address_longitude double precision,
    delivery_address_latitude double precision,
    invoice_address_field1 character varying(500),
    invoice_address_field2 character varying(500),
    invoice_address_field3 character varying(500),
    invoice_address_street character varying(255),
    invoice_address_street_number character varying(10),
    invoice_address_zip_code character varying(255),
    invoice_address_city character varying(255),
    commentary text,
    date_created timestamp without time zone NOT NULL,
    last_modified timestamp without time zone NOT NULL,
    discount_rate real DEFAULT 0,
    invoice_address_longitude double precision,
    invoice_address_latitude double precision,
    customer_id character varying(255) NOT NULL,
    delivery_address_country_id character varying(255),
    invoice_address_country_id character varying(255),
    customer_type_id character varying(255),
    customer_category_id character varying(255),
    contact_person_name character varying(255),
    contact_person_email character varying(255),
    contact_person_phone character varying(255),
    website_url character varying(255)
);


ALTER TABLE public.customer OWNER TO crm_user;

--
-- TOC entry 1651 (class 0 OID 0)
-- Dependencies: 1278
-- Name: TABLE customer; Type: COMMENT; Schema: public; Owner: crm_user
--

COMMENT ON TABLE customer IS 'all customers handled by this system';


--
-- TOC entry 1652 (class 0 OID 0)
-- Dependencies: 1278
-- Name: COLUMN customer.name; Type: COMMENT; Schema: public; Owner: crm_user
--

COMMENT ON COLUMN customer.name IS 'full name of the person or company';


--
-- TOC entry 1653 (class 0 OID 0)
-- Dependencies: 1278
-- Name: COLUMN customer.customer_number; Type: COMMENT; Schema: public; Owner: crm_user
--

COMMENT ON COLUMN customer.customer_number IS 'the customer number is used by humans (e.g. staffer, customer) while customer_id is database internal';


--
-- TOC entry 1654 (class 0 OID 0)
-- Dependencies: 1278
-- Name: COLUMN customer.delivery_address_field2; Type: COMMENT; Schema: public; Owner: crm_user
--

COMMENT ON COLUMN customer.delivery_address_field2 IS 'anything that doesn''t fit in other address columns';


--
-- TOC entry 1655 (class 0 OID 0)
-- Dependencies: 1278
-- Name: COLUMN customer.delivery_address_field3; Type: COMMENT; Schema: public; Owner: crm_user
--

COMMENT ON COLUMN customer.delivery_address_field3 IS 'anything that doesn''t fit in other address columns';


--
-- TOC entry 1656 (class 0 OID 0)
-- Dependencies: 1278
-- Name: COLUMN customer.delivery_address_field1; Type: COMMENT; Schema: public; Owner: crm_user
--

COMMENT ON COLUMN customer.delivery_address_field1 IS 'anything that doesn''t fit in other address columns';


--
-- TOC entry 1657 (class 0 OID 0)
-- Dependencies: 1278
-- Name: COLUMN customer.delivery_address_street; Type: COMMENT; Schema: public; Owner: crm_user
--

COMMENT ON COLUMN customer.delivery_address_street IS 'street name';


--
-- TOC entry 1658 (class 0 OID 0)
-- Dependencies: 1278
-- Name: COLUMN customer.delivery_address_street_number; Type: COMMENT; Schema: public; Owner: crm_user
--

COMMENT ON COLUMN customer.delivery_address_street_number IS 'house number';


--
-- TOC entry 1659 (class 0 OID 0)
-- Dependencies: 1278
-- Name: COLUMN customer.delivery_address_zip_code; Type: COMMENT; Schema: public; Owner: crm_user
--

COMMENT ON COLUMN customer.delivery_address_zip_code IS 'code for the city';


--
-- TOC entry 1660 (class 0 OID 0)
-- Dependencies: 1278
-- Name: COLUMN customer.delivery_address_city; Type: COMMENT; Schema: public; Owner: crm_user
--

COMMENT ON COLUMN customer.delivery_address_city IS 'name of the town';


--
-- TOC entry 1661 (class 0 OID 0)
-- Dependencies: 1278
-- Name: COLUMN customer.delivery_address_longitude; Type: COMMENT; Schema: public; Owner: crm_user
--

COMMENT ON COLUMN customer.delivery_address_longitude IS 'can be determined with http://www.togis.com/address_geodecoder';


--
-- TOC entry 1662 (class 0 OID 0)
-- Dependencies: 1278
-- Name: COLUMN customer.delivery_address_latitude; Type: COMMENT; Schema: public; Owner: crm_user
--

COMMENT ON COLUMN customer.delivery_address_latitude IS 'can be determined with http://www.togis.com/address_geodecoder';


--
-- TOC entry 1663 (class 0 OID 0)
-- Dependencies: 1278
-- Name: COLUMN customer.invoice_address_field1; Type: COMMENT; Schema: public; Owner: crm_user
--

COMMENT ON COLUMN customer.invoice_address_field1 IS 'anything that doesn''t fit in other address columns';


--
-- TOC entry 1664 (class 0 OID 0)
-- Dependencies: 1278
-- Name: COLUMN customer.invoice_address_field2; Type: COMMENT; Schema: public; Owner: crm_user
--

COMMENT ON COLUMN customer.invoice_address_field2 IS 'anything that doesn''t fit in other address columns';


--
-- TOC entry 1665 (class 0 OID 0)
-- Dependencies: 1278
-- Name: COLUMN customer.invoice_address_field3; Type: COMMENT; Schema: public; Owner: crm_user
--

COMMENT ON COLUMN customer.invoice_address_field3 IS 'anything that doesn''t fit in other address columns';


--
-- TOC entry 1666 (class 0 OID 0)
-- Dependencies: 1278
-- Name: COLUMN customer.invoice_address_street; Type: COMMENT; Schema: public; Owner: crm_user
--

COMMENT ON COLUMN customer.invoice_address_street IS 'street name';


--
-- TOC entry 1667 (class 0 OID 0)
-- Dependencies: 1278
-- Name: COLUMN customer.invoice_address_street_number; Type: COMMENT; Schema: public; Owner: crm_user
--

COMMENT ON COLUMN customer.invoice_address_street_number IS 'house number';


--
-- TOC entry 1668 (class 0 OID 0)
-- Dependencies: 1278
-- Name: COLUMN customer.invoice_address_zip_code; Type: COMMENT; Schema: public; Owner: crm_user
--

COMMENT ON COLUMN customer.invoice_address_zip_code IS 'code for the city';


--
-- TOC entry 1669 (class 0 OID 0)
-- Dependencies: 1278
-- Name: COLUMN customer.invoice_address_city; Type: COMMENT; Schema: public; Owner: crm_user
--

COMMENT ON COLUMN customer.invoice_address_city IS 'name of the town';


--
-- TOC entry 1670 (class 0 OID 0)
-- Dependencies: 1278
-- Name: COLUMN customer.commentary; Type: COMMENT; Schema: public; Owner: crm_user
--

COMMENT ON COLUMN customer.commentary IS 'anything that doesn''t fit in other table columns';


--
-- TOC entry 1671 (class 0 OID 0)
-- Dependencies: 1278
-- Name: COLUMN customer.date_created; Type: COMMENT; Schema: public; Owner: crm_user
--

COMMENT ON COLUMN customer.date_created IS 'is automatically set on each row when it is inserted';


--
-- TOC entry 1672 (class 0 OID 0)
-- Dependencies: 1278
-- Name: COLUMN customer.last_modified; Type: COMMENT; Schema: public; Owner: crm_user
--

COMMENT ON COLUMN customer.last_modified IS 'is automatically set on each row when it changes';


--
-- TOC entry 1673 (class 0 OID 0)
-- Dependencies: 1278
-- Name: COLUMN customer.discount_rate; Type: COMMENT; Schema: public; Owner: crm_user
--

COMMENT ON COLUMN customer.discount_rate IS 'value between 0.0 and 1.0. 0.0 means: customer pays full price, 0.1 means the customer must pay 90% of the full price';


--
-- TOC entry 1674 (class 0 OID 0)
-- Dependencies: 1278
-- Name: COLUMN customer.invoice_address_longitude; Type: COMMENT; Schema: public; Owner: crm_user
--

COMMENT ON COLUMN customer.invoice_address_longitude IS 'can be determined with http://www.togis.com/address_geodecoder';


--
-- TOC entry 1675 (class 0 OID 0)
-- Dependencies: 1278
-- Name: COLUMN customer.invoice_address_latitude; Type: COMMENT; Schema: public; Owner: crm_user
--

COMMENT ON COLUMN customer.invoice_address_latitude IS 'can be determined with http://www.togis.com/address_geodecoder';


--
-- TOC entry 1676 (class 0 OID 0)
-- Dependencies: 1278
-- Name: COLUMN customer.customer_id; Type: COMMENT; Schema: public; Owner: crm_user
--

COMMENT ON COLUMN customer.customer_id IS 'PK';


--
-- TOC entry 1677 (class 0 OID 0)
-- Dependencies: 1278
-- Name: COLUMN customer.delivery_address_country_id; Type: COMMENT; Schema: public; Owner: crm_user
--

COMMENT ON COLUMN customer.delivery_address_country_id IS 'FK; cf. ISO 3166';


--
-- TOC entry 1678 (class 0 OID 0)
-- Dependencies: 1278
-- Name: COLUMN customer.invoice_address_country_id; Type: COMMENT; Schema: public; Owner: crm_user
--

COMMENT ON COLUMN customer.invoice_address_country_id IS 'FK; cf. ISO 3166';


--
-- TOC entry 1679 (class 0 OID 0)
-- Dependencies: 1278
-- Name: COLUMN customer.customer_type_id; Type: COMMENT; Schema: public; Owner: crm_user
--

COMMENT ON COLUMN customer.customer_type_id IS 'FK; business customer, private, reseller etc.';


--
-- TOC entry 1680 (class 0 OID 0)
-- Dependencies: 1278
-- Name: COLUMN customer.customer_category_id; Type: COMMENT; Schema: public; Owner: crm_user
--

COMMENT ON COLUMN customer.customer_category_id IS 'FK; the importance of the customer; A is most, C is least important';


--
-- TOC entry 1279 (class 1259 OID 239024)
-- Dependencies: 5
-- Name: customer_category; Type: TABLE; Schema: public; Owner: crm_user; Tablespace: 
--

CREATE TABLE customer_category (
    date_created timestamp without time zone NOT NULL,
    last_modified timestamp without time zone NOT NULL,
    customer_category_name character varying(255) NOT NULL,
    customer_category_key character varying(20) NOT NULL,
    customer_category_id character varying(255) NOT NULL
);


ALTER TABLE public.customer_category OWNER TO crm_user;

--
-- TOC entry 1681 (class 0 OID 0)
-- Dependencies: 1279
-- Name: TABLE customer_category; Type: COMMENT; Schema: public; Owner: crm_user
--

COMMENT ON TABLE customer_category IS 'the importance of the customer';


--
-- TOC entry 1682 (class 0 OID 0)
-- Dependencies: 1279
-- Name: COLUMN customer_category.date_created; Type: COMMENT; Schema: public; Owner: crm_user
--

COMMENT ON COLUMN customer_category.date_created IS 'is automatically set on each row when it is inserted';


--
-- TOC entry 1683 (class 0 OID 0)
-- Dependencies: 1279
-- Name: COLUMN customer_category.last_modified; Type: COMMENT; Schema: public; Owner: crm_user
--

COMMENT ON COLUMN customer_category.last_modified IS 'is automatically set on each row when it changes';


--
-- TOC entry 1684 (class 0 OID 0)
-- Dependencies: 1279
-- Name: COLUMN customer_category.customer_category_name; Type: COMMENT; Schema: public; Owner: crm_user
--

COMMENT ON COLUMN customer_category.customer_category_name IS 'name that describes the category';


--
-- TOC entry 1685 (class 0 OID 0)
-- Dependencies: 1279
-- Name: COLUMN customer_category.customer_category_key; Type: COMMENT; Schema: public; Owner: crm_user
--

COMMENT ON COLUMN customer_category.customer_category_key IS 'key for accessing the customer category';


--
-- TOC entry 1280 (class 1259 OID 239029)
-- Dependencies: 5
-- Name: customer_type; Type: TABLE; Schema: public; Owner: crm_user; Tablespace: 
--

CREATE TABLE customer_type (
    date_created timestamp without time zone NOT NULL,
    last_modified timestamp without time zone NOT NULL,
    customer_type_name character varying(255) NOT NULL,
    customer_type_key character varying(20) NOT NULL,
    customer_type_id character varying(255) NOT NULL
);


ALTER TABLE public.customer_type OWNER TO crm_user;

--
-- TOC entry 1686 (class 0 OID 0)
-- Dependencies: 1280
-- Name: TABLE customer_type; Type: COMMENT; Schema: public; Owner: crm_user
--

COMMENT ON TABLE customer_type IS 'The type can be business customer, private, reseller etc.';


--
-- TOC entry 1687 (class 0 OID 0)
-- Dependencies: 1280
-- Name: COLUMN customer_type.customer_type_id; Type: COMMENT; Schema: public; Owner: crm_user
--

COMMENT ON COLUMN customer_type.customer_type_id IS 'PK';


--
-- TOC entry 1281 (class 1259 OID 239034)
-- Dependencies: 5
-- Name: hibernate_sequence; Type: SEQUENCE; Schema: public; Owner: crm_user
--

CREATE SEQUENCE hibernate_sequence
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.hibernate_sequence OWNER TO crm_user;

--
-- TOC entry 1627 (class 2606 OID 239037)
-- Dependencies: 1280 1280
-- Name: customer_type_pkey; Type: CONSTRAINT; Schema: public; Owner: crm_user; Tablespace: 
--

ALTER TABLE ONLY customer_type
    ADD CONSTRAINT customer_type_pkey PRIMARY KEY (customer_type_id);


--
-- TOC entry 1688 (class 0 OID 0)
-- Dependencies: 1627
-- Name: CONSTRAINT customer_type_pkey ON customer_type; Type: COMMENT; Schema: public; Owner: crm_user
--

COMMENT ON CONSTRAINT customer_type_pkey ON customer_type IS 'PK constraint';


--
-- TOC entry 1615 (class 2606 OID 239039)
-- Dependencies: 1277 1277
-- Name: iso_code_unique; Type: CONSTRAINT; Schema: public; Owner: crm_user; Tablespace: 
--

ALTER TABLE ONLY country
    ADD CONSTRAINT iso_code_unique UNIQUE (iso_code);


--
-- TOC entry 1689 (class 0 OID 0)
-- Dependencies: 1615
-- Name: CONSTRAINT iso_code_unique ON country; Type: COMMENT; Schema: public; Owner: crm_user
--

COMMENT ON CONSTRAINT iso_code_unique ON country IS 'The ISO Code can be used as key by the application.';


--
-- TOC entry 1617 (class 2606 OID 239041)
-- Dependencies: 1277 1277
-- Name: pk_country; Type: CONSTRAINT; Schema: public; Owner: crm_user; Tablespace: 
--

ALTER TABLE ONLY country
    ADD CONSTRAINT pk_country PRIMARY KEY (country_id);


--
-- TOC entry 1690 (class 0 OID 0)
-- Dependencies: 1617
-- Name: CONSTRAINT pk_country ON country; Type: COMMENT; Schema: public; Owner: crm_user
--

COMMENT ON CONSTRAINT pk_country ON country IS 'PK';


--
-- TOC entry 1623 (class 2606 OID 239043)
-- Dependencies: 1278 1278
-- Name: pk_customer; Type: CONSTRAINT; Schema: public; Owner: crm_user; Tablespace: 
--

ALTER TABLE ONLY customer
    ADD CONSTRAINT pk_customer PRIMARY KEY (customer_id);


--
-- TOC entry 1691 (class 0 OID 0)
-- Dependencies: 1623
-- Name: CONSTRAINT pk_customer ON customer; Type: COMMENT; Schema: public; Owner: crm_user
--

COMMENT ON CONSTRAINT pk_customer ON customer IS 'Primary Key Customer';


--
-- TOC entry 1625 (class 2606 OID 239045)
-- Dependencies: 1279 1279
-- Name: pk_customer_category; Type: CONSTRAINT; Schema: public; Owner: crm_user; Tablespace: 
--

ALTER TABLE ONLY customer_category
    ADD CONSTRAINT pk_customer_category PRIMARY KEY (customer_category_id);


--
-- TOC entry 1692 (class 0 OID 0)
-- Dependencies: 1625
-- Name: CONSTRAINT pk_customer_category ON customer_category; Type: COMMENT; Schema: public; Owner: crm_user
--

COMMENT ON CONSTRAINT pk_customer_category ON customer_category IS 'PK constraint';


--
-- TOC entry 1618 (class 1259 OID 239046)
-- Dependencies: 1278
-- Name: fki_; Type: INDEX; Schema: public; Owner: crm_user; Tablespace: 
--

CREATE INDEX fki_ ON customer USING btree (delivery_address_country_id);


--
-- TOC entry 1619 (class 1259 OID 239047)
-- Dependencies: 1278
-- Name: fki_customer_category; Type: INDEX; Schema: public; Owner: crm_user; Tablespace: 
--

CREATE INDEX fki_customer_category ON customer USING btree (customer_category_id);


--
-- TOC entry 1620 (class 1259 OID 239048)
-- Dependencies: 1278
-- Name: fki_customer_type; Type: INDEX; Schema: public; Owner: crm_user; Tablespace: 
--

CREATE INDEX fki_customer_type ON customer USING btree (customer_type_id);


--
-- TOC entry 1621 (class 1259 OID 239049)
-- Dependencies: 1278
-- Name: fki_delivery_country; Type: INDEX; Schema: public; Owner: crm_user; Tablespace: 
--

CREATE INDEX fki_delivery_country ON customer USING btree (invoice_address_country_id);


--
-- TOC entry 1613 (class 1259 OID 239050)
-- Dependencies: 1277
-- Name: idx_country_name; Type: INDEX; Schema: public; Owner: crm_user; Tablespace: 
--

CREATE INDEX idx_country_name ON country USING btree (name);


--
-- TOC entry 1632 (class 2620 OID 239051)
-- Dependencies: 1277 18
-- Name: trigger_created_country; Type: TRIGGER; Schema: public; Owner: crm_user
--

CREATE TRIGGER trigger_created_country
    BEFORE INSERT ON country
    FOR EACH ROW
    EXECUTE PROCEDURE update_created_column();


--
-- TOC entry 1693 (class 0 OID 0)
-- Dependencies: 1632
-- Name: TRIGGER trigger_created_country ON country; Type: COMMENT; Schema: public; Owner: crm_user
--

COMMENT ON TRIGGER trigger_created_country ON country IS 'fires when a row is inserted to call a function which updates the date_created field';


--
-- TOC entry 1634 (class 2620 OID 239052)
-- Dependencies: 1278 18
-- Name: trigger_created_customer; Type: TRIGGER; Schema: public; Owner: crm_user
--

CREATE TRIGGER trigger_created_customer
    BEFORE INSERT ON customer
    FOR EACH ROW
    EXECUTE PROCEDURE update_created_column();


--
-- TOC entry 1694 (class 0 OID 0)
-- Dependencies: 1634
-- Name: TRIGGER trigger_created_customer ON customer; Type: COMMENT; Schema: public; Owner: crm_user
--

COMMENT ON TRIGGER trigger_created_customer ON customer IS 'fires when a row is inserted to call a function which updates the date_created field';


--
-- TOC entry 1636 (class 2620 OID 239053)
-- Dependencies: 1279 18
-- Name: trigger_created_customer_category; Type: TRIGGER; Schema: public; Owner: crm_user
--

CREATE TRIGGER trigger_created_customer_category
    BEFORE INSERT ON customer_category
    FOR EACH ROW
    EXECUTE PROCEDURE update_created_column();


--
-- TOC entry 1695 (class 0 OID 0)
-- Dependencies: 1636
-- Name: TRIGGER trigger_created_customer_category ON customer_category; Type: COMMENT; Schema: public; Owner: crm_user
--

COMMENT ON TRIGGER trigger_created_customer_category ON customer_category IS 'fires when a row is inserted to call a function which updates the date_created field';


--
-- TOC entry 1638 (class 2620 OID 239054)
-- Dependencies: 1280 18
-- Name: trigger_created_customer_type; Type: TRIGGER; Schema: public; Owner: crm_user
--

CREATE TRIGGER trigger_created_customer_type
    BEFORE INSERT ON customer_type
    FOR EACH ROW
    EXECUTE PROCEDURE update_created_column();


--
-- TOC entry 1696 (class 0 OID 0)
-- Dependencies: 1638
-- Name: TRIGGER trigger_created_customer_type ON customer_type; Type: COMMENT; Schema: public; Owner: crm_user
--

COMMENT ON TRIGGER trigger_created_customer_type ON customer_type IS 'fires when a row is inserted to call a function which updates the date_created field';


--
-- TOC entry 1633 (class 2620 OID 239055)
-- Dependencies: 19 1277
-- Name: trigger_modified_country; Type: TRIGGER; Schema: public; Owner: crm_user
--

CREATE TRIGGER trigger_modified_country
    BEFORE INSERT OR UPDATE ON country
    FOR EACH ROW
    EXECUTE PROCEDURE update_modified_column();


--
-- TOC entry 1697 (class 0 OID 0)
-- Dependencies: 1633
-- Name: TRIGGER trigger_modified_country ON country; Type: COMMENT; Schema: public; Owner: crm_user
--

COMMENT ON TRIGGER trigger_modified_country ON country IS 'fires when a row is updated to call a function which updates the last_modified field';


--
-- TOC entry 1635 (class 2620 OID 239056)
-- Dependencies: 19 1278
-- Name: trigger_modified_customer; Type: TRIGGER; Schema: public; Owner: crm_user
--

CREATE TRIGGER trigger_modified_customer
    BEFORE INSERT OR UPDATE ON customer
    FOR EACH ROW
    EXECUTE PROCEDURE update_modified_column();


--
-- TOC entry 1698 (class 0 OID 0)
-- Dependencies: 1635
-- Name: TRIGGER trigger_modified_customer ON customer; Type: COMMENT; Schema: public; Owner: crm_user
--

COMMENT ON TRIGGER trigger_modified_customer ON customer IS 'fires when a row is updated to call a function which updates the last_modified field';


--
-- TOC entry 1637 (class 2620 OID 239057)
-- Dependencies: 19 1279
-- Name: trigger_modified_customer_category; Type: TRIGGER; Schema: public; Owner: crm_user
--

CREATE TRIGGER trigger_modified_customer_category
    BEFORE INSERT OR UPDATE ON customer_category
    FOR EACH ROW
    EXECUTE PROCEDURE update_modified_column();


--
-- TOC entry 1699 (class 0 OID 0)
-- Dependencies: 1637
-- Name: TRIGGER trigger_modified_customer_category ON customer_category; Type: COMMENT; Schema: public; Owner: crm_user
--

COMMENT ON TRIGGER trigger_modified_customer_category ON customer_category IS 'fires when a row is updated to call a function which updates the last_modified field';


--
-- TOC entry 1639 (class 2620 OID 239058)
-- Dependencies: 1280 19
-- Name: trigger_modified_customer_type; Type: TRIGGER; Schema: public; Owner: crm_user
--

CREATE TRIGGER trigger_modified_customer_type
    BEFORE INSERT OR UPDATE ON customer_type
    FOR EACH ROW
    EXECUTE PROCEDURE update_modified_column();


--
-- TOC entry 1700 (class 0 OID 0)
-- Dependencies: 1639
-- Name: TRIGGER trigger_modified_customer_type ON customer_type; Type: COMMENT; Schema: public; Owner: crm_user
--

COMMENT ON TRIGGER trigger_modified_customer_type ON customer_type IS 'fires when a row is updated to call a function which updates the last_modified field';


--
-- TOC entry 1628 (class 2606 OID 239059)
-- Dependencies: 1279 1624 1278
-- Name: customer_category; Type: FK CONSTRAINT; Schema: public; Owner: crm_user
--

ALTER TABLE ONLY customer
    ADD CONSTRAINT customer_category FOREIGN KEY (customer_category_id) REFERENCES customer_category(customer_category_id);


--
-- TOC entry 1701 (class 0 OID 0)
-- Dependencies: 1628
-- Name: CONSTRAINT customer_category ON customer; Type: COMMENT; Schema: public; Owner: crm_user
--

COMMENT ON CONSTRAINT customer_category ON customer IS 'customer_category fk';


--
-- TOC entry 1629 (class 2606 OID 239064)
-- Dependencies: 1616 1278 1277
-- Name: customer_delivery_address_country_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: crm_user
--

ALTER TABLE ONLY customer
    ADD CONSTRAINT customer_delivery_address_country_id_fkey FOREIGN KEY (delivery_address_country_id) REFERENCES country(country_id);


--
-- TOC entry 1702 (class 0 OID 0)
-- Dependencies: 1629
-- Name: CONSTRAINT customer_delivery_address_country_id_fkey ON customer; Type: COMMENT; Schema: public; Owner: crm_user
--

COMMENT ON CONSTRAINT customer_delivery_address_country_id_fkey ON customer IS 'FK; cf. ISO 3166';


--
-- TOC entry 1630 (class 2606 OID 239069)
-- Dependencies: 1626 1280 1278
-- Name: customer_type; Type: FK CONSTRAINT; Schema: public; Owner: crm_user
--

ALTER TABLE ONLY customer
    ADD CONSTRAINT customer_type FOREIGN KEY (customer_type_id) REFERENCES customer_type(customer_type_id) DEFERRABLE;


--
-- TOC entry 1703 (class 0 OID 0)
-- Dependencies: 1630
-- Name: CONSTRAINT customer_type ON customer; Type: COMMENT; Schema: public; Owner: crm_user
--

COMMENT ON CONSTRAINT customer_type ON customer IS 'The type can be business customer, private, reseller etc.';


--
-- TOC entry 1631 (class 2606 OID 239074)
-- Dependencies: 1616 1277 1278
-- Name: delivery_country; Type: FK CONSTRAINT; Schema: public; Owner: crm_user
--

ALTER TABLE ONLY customer
    ADD CONSTRAINT delivery_country FOREIGN KEY (invoice_address_country_id) REFERENCES country(country_id);


--
-- TOC entry 1704 (class 0 OID 0)
-- Dependencies: 1631
-- Name: CONSTRAINT delivery_country ON customer; Type: COMMENT; Schema: public; Owner: crm_user
--

COMMENT ON CONSTRAINT delivery_country ON customer IS 'FK; cf. ISO 3166';


--
-- TOC entry 1644 (class 0 OID 0)
-- Dependencies: 5
-- Name: public; Type: ACL; Schema: -; Owner: postgres
--

REVOKE ALL ON SCHEMA public FROM PUBLIC;
REVOKE ALL ON SCHEMA public FROM postgres;
GRANT ALL ON SCHEMA public TO postgres;
GRANT ALL ON SCHEMA public TO PUBLIC;


-- Completed on 2009-01-07 16:59:03

--
-- PostgreSQL database dump complete
--

