package org.pluginbuilder.anttasks;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.RegularExpression;
import org.apache.tools.ant.util.regexp.Regexp;

public class SetRegex extends Task {

  private String input;
  private String property;
  private String match;
  private String value;

  public void execute() throws BuildException {
    if (input == null) {
      throw new BuildException( "Missing input in setregex" );
    }
    if (match == null) {
      throw new BuildException( "Missing match in setregex" );
    }
    RegularExpression regularExpression = new RegularExpression();
    regularExpression.setPattern( match );
    Regexp regexp = regularExpression.getRegexp( getProject() );
    if (!regexp.matches( input, Regexp.MATCH_SINGLELINE )) {
      return;
    }
    String substituted = regexp.substitute( input, value, Regexp.MATCH_SINGLELINE );
    getProject().setProperty( property, substituted );
  }

  public void setInput(String input) {
    this.input = input;
  }

  public void setProperty(String property) {
    this.property = property;
  }

  public void setMatch(String match) {
    this.match = match;
  }

  public void setValue(String value) {
    this.value = value;
  }
}
