package spec.benchmarks._239_nih; 
//Implements the Edit/Undo command.

import java.awt.*;
import java.awt.image.*;

class Undo {

	static final int NOTHING = 0;
	static final int FILTER = 1;
	static final int TYPE_CONVERSION = 2;
	
	private static int whatToUndo = NOTHING;
	private static ImagePlus imp = null;
	private static Image imageCopy = null;
	
	
	static void setup(int what,ImagePlus imgPlus) {
		whatToUndo = what;
		imp = imgPlus;
		if (what==FILTER)
			imageCopy = null;
		else
			imageCopy = imp.getImage();
		if (Info.debugMode) Info.write(imp.getTitle() + ": set up undo (" + what + ")");
	}
	
	
	static void reset() {
		whatToUndo = NOTHING;
		imp = null;
		imageCopy = null;
		if (Info.debugMode) Info.write("Undo: reset");
	}
	

	static void undo() {
		if (imp!=WindowManager.getCurrentImage())
			imp = null;
		switch (whatToUndo) {
			case FILTER:
				if (imp!=null)
					imp.undoFilter();
	    		break;
			case TYPE_CONVERSION:
				if (imp!=null) {
					imp.setImage(imageCopy);
		    		imp.draw();
					if (Info.debugMode) Info.write(imp.getTitle() + ": undo type conversion");
		    	}
	    		break;
    	}
    	reset();
	}
	
}
