package spec.benchmarks._239_nih; 
//Saves images as uncompressed TIFF files

import java.io.*;

class TiffEncoder {
	FileInfo fi;
	

	TiffEncoder (FileInfo fi) {
		this.fi = fi;
	}
	

	void write(DataOutputStream out) throws IOException {
	// Saves the image as a TIFF file
		writeHeader(out);
		writeIFD(out);
		ImageWriter file = new ImageWriter(fi);
		file.write(out);
		if (fi.fileType==FileInfo.COLOR8)
			writeColorMap(out);
	}
	

	void writeHeader(DataOutputStream out) throws IOException {
	// Writes 8-byte image file header
		byte[] hdr = new byte[8];
		hdr[0] = 77; // "MM" (Motorola byte order)
		hdr[1] = 77;
		hdr[2] = 0;  // 42 (magic number)
		hdr[3] = 42;
		hdr[4] = 0;  // 8 (offset to first IFD)
		hdr[5] = 0;
		hdr[6] = 0;
		hdr[7] = 8;
		out.write(hdr);
	}
	

	void writeEntry(DataOutputStream out, int tag, int fieldType, int count, int value) throws IOException {
	// Writes one 12-byte IFD entry
		out.writeShort(tag);
		out.writeShort(fieldType);
		out.writeInt(count);
		if (count==1 && fieldType==3)
			value <<= 16;
		out.writeInt(value);
	}
	
	
	void writeIFD(DataOutputStream out) throws IOException {
	// Writes the IFD (Image File Directory)
		int headerSize;
		int nEntries;
		byte[] filler;
		int bitsPerSample, photoInterp, samplesPerPixel, byteCount;
		int bitsPerSampleOffset;
			
		bitsPerSample = 8;
		samplesPerPixel = 1;
		byteCount = fi.width*fi.height;
		switch (fi.fileType) {
			case FileInfo.GRAY8:
				photoInterp = fi.blackIsZero?1:0;
				break;
			case FileInfo.GRAY16:
				bitsPerSample = 16;
				photoInterp = fi.blackIsZero?1:0;
				byteCount = byteCount*2;
				break;
			case FileInfo.GRAY32_FLOAT:
				bitsPerSample = 32;
				photoInterp = fi.blackIsZero?1:0;
				byteCount = byteCount*4;
				break;
			case FileInfo.RGB:
				photoInterp = 2;
				samplesPerPixel = 3;
				byteCount = byteCount*3;
				break;
			case FileInfo.COLOR8:
				photoInterp = 3;
				break;
			default:
				photoInterp = 0;
		}

		if (fi.fileType==FileInfo.COLOR8)
			nEntries = 10;
		else
			nEntries = 9;
		headerSize = 8 + 2 + nEntries*12 + 4; // Tiff hdr + nEntries + IFD + 0
		bitsPerSampleOffset = headerSize;
		out.writeShort(nEntries);
		writeEntry(out, TiffDecoder.NEW_SUBFILE_TYPE, 4, 1, 0);
		writeEntry(out, TiffDecoder.IMAGE_WIDTH,      3, 1, fi.width);
		writeEntry(out, TiffDecoder.IMAGE_LENGTH,     3, 1, fi.height);
		if (fi.fileType==FileInfo.RGB)
			writeEntry(out, TiffDecoder.BITS_PER_SAMPLE,  3, 3, bitsPerSampleOffset);
		else
			writeEntry(out, TiffDecoder.BITS_PER_SAMPLE,  3, 1, bitsPerSample);
		writeEntry(out, TiffDecoder.PHOTO_INTERP,     3, 1, photoInterp);
		writeEntry(out, TiffDecoder.STRIP_OFFSETS,    4, 1, 768);
		writeEntry(out, TiffDecoder.SAMPLES_PER_PIXEL,3, 1, samplesPerPixel);
		writeEntry(out, TiffDecoder.ROWS_PER_STRIP,   3, 1, fi.height);
		writeEntry(out, TiffDecoder.STRIP_BYTE_COUNT, 4, 1, byteCount);
		if (fi.fileType==FileInfo.COLOR8)
			writeEntry(out, TiffDecoder.COLOR_MAP, 3, 768, 768+byteCount);
		out.writeInt(0);
		
		if (fi.fileType==FileInfo.RGB) {
			out.writeShort(8);
			out.writeShort(8);
			out.writeShort(8);
			headerSize += 6;
		}
		
		filler = new byte[768 - headerSize];
		out.write(filler); // Forces image to start at offset 768
	}
	

	void writeColorMap(DataOutputStream out) throws IOException {
		byte[] colorTable16 = new byte[768*2];
		int j=0;
		for (int i=0; i<768; i++) {
			 colorTable16[j]=fi.colorTable[i];
			j += 2;
		}
		out.write(colorTable16);
	}
	
}

