package spec.benchmarks._239_nih; 
// 16-bit image statistics, including histogram

class ShortStatistics extends ImageStatistics {

	ShortStatistics(ImageProcessor ip) {
		this.width = ip.getWidth();
		this.height = ip.getHeight();
		setRoiLimits(ip.getRoi());
		ShortProcessor sp = (ShortProcessor)ip;
		min = sp.getMin();
		max = sp.getMax();
		histMin = min;
		histMax = max;
		getHistogram(ip);
		getMode();
	}


	void getHistogram(ImageProcessor ip) {
		int v;
		short[] pixels = (short[])ip.getPixels();
		histogram = new int[nBins];
		double scale = (float)((nBins-1)/(histMax-histMin));
		int hMin = (int)histMin;
		binSize = (histMax - histMin)/nBins;
		int sum = 0;
		int roiMin = Integer.MAX_VALUE;
		int roiMax = Integer.MIN_VALUE;
		boolean isRoi = roiX!=0;
		
		for (int y=roiY; y<(roiY+roiHeight); y++) {
			int i = y * width + roiX;
			for (int x=roiX; x<(roiX+roiWidth); x++) {
				v = pixels[i++];
				histogram[(int)(scale*(v-hMin))]++;
				sum += v;
				if (isRoi) {
					if (v<roiMin) roiMin = v;
					if (v>roiMax) roiMax = v;
				}
			}
		}
		pixelCount = roiWidth*roiHeight;
		mean = (double)sum/pixelCount;
		if (isRoi) {
			min = roiMin;
			max = roiMax;
		}
	}


	void getMode() {
        int count;
        maxCount = 0;
        for (int i = 0; i < nBins; i++) {
        	count = histogram[i];
            if (count > maxCount) {
                maxCount = count;
                mode = i;
            }
        }
	}

}