package spec.benchmarks._239_nih; 
// Rectangular region of interest

import java.awt.*;
import java.awt.image.*;

class Roi {

	static final int CONSTRUCTING=0, MOVING=1, RESIZING=2, NORMAL=3; // States
	static final int RECTANGLE=0, OVAL=1, POLYGON=2, FREEHAND=3; // Types
	
	int startX, startY, x, y, width, height;
	int state;
	
	protected int type;
	protected int xMax, yMax;
	protected ImagePlus imp;
	protected int oldX, oldY, oldWidth, oldHeight;
	protected int clipX, clipY, clipWidth, clipHeight;


	Roi(int x, int y, ImagePlus imp) {
		this.imp = imp;
		xMax = imp.getWidth();
		yMax = imp.getHeight();
		startX = x;
		startY = y;
		this.x = startX;
		this.y = startY;
		width = 0;
		height = 0;
		state = CONSTRUCTING;
		oldX = x; oldY = y; oldWidth=0; oldHeight=0;
		imp.draw();
		type = RECTANGLE;
	}
	

	public int getType() {
		return type;
	}
	
	
	public Rectangle getBoundingRect() {
			return new Rectangle(x, y, width, height);
	}
	
	
	protected void grow(int xNew, int yNew) {
		width = Math.abs(xNew - startX);
		height = Math.abs(yNew - startY);
		x = (xNew >= startX)?startX:startX - width;
		y = (yNew >= startY)?startY:startY - height;
		if ((x + width) >= xMax)
			width = xMax - x - 1;
		if ((y + height) >= yMax)
			height = yMax - y - 1;
		updateClipRect();
		imp.draw(clipX, clipY, clipWidth, clipHeight);
		oldX = x;
		oldY = y;
		oldWidth = width;
		oldHeight=height;
	}


	//void fill() {
	//	ImageCanvas ic = imp.getWindow().getCanvas();
	//	Graphics g = ic.getGraphics();
	//	g.setColor(Color.red);
	//	g.fillRect(0, 0, xMax, yMax);
	//}


	void move(int xNew, int yNew) {
		x += xNew - startX;
		y += yNew - startY;
		if (x < 0) x = 0;
		if (y < 0) y = 0;
		if ((x + width) >= xMax) x = xMax - width - 1;
		if ((y + height) >= yMax) y = yMax - height - 1;
		startX = xNew;
		startY = yNew;
		updateClipRect();
		imp.draw(clipX, clipY, clipWidth, clipHeight);
		oldX = x; oldY = y;
	}


	protected void updateClipRect() {
	// Finds the union of current and previous roi
		clipX = (x<=oldX)?x:oldX;
		clipY = (y<=oldY)?y:oldY;
		clipWidth = ((x+width>=oldX+oldWidth)?x+width:oldX+oldWidth) - clipX + 1;
		clipHeight = ((y+height>=oldY+oldHeight)?y+height:oldY+oldHeight) - clipY + 1;
	}
	
	
	void handleMouseDrag(int x, int y, boolean constrain) {
		if (x < 0) x = 0;
		if (y < 0) y = 0;
		if (x >= xMax) x = xMax - 1;
		if (y >= yMax) y = yMax - 1;
		if (constrain) {
			// constrain selection to be square
			int dx, dy, d;
			dx = x - this.x;
			dy = y - this.y;
			if (dx<dy)
				d = dx;
			else
				d = dy;
			x = this.x + d;
			y = this.y + d;
		}
		switch(state) {
			case CONSTRUCTING:
				grow(x, y);
				break;
			case MOVING:
				move(x, y);
				break;
			default:
				break;
		}
	}


	void draw(Graphics g) {
		double mag = imp.getMagnification();
		g.setColor(Color.yellow);
		g.drawRect(imp.screenX(x), imp.screenY(y), (int)(width*mag), (int)(height*mag));
		showStatus();
	}


	public boolean contains(int x, int y) {
		Rectangle r = new Rectangle(this.x, this.y, width, height);
		return r.inside(x, y);
	}
	
	
	void handleMouseDown(int xDown, int yDown) {
		if (state==NORMAL) {
			state = MOVING;
			startX = xDown;
			startY = yDown;
			showStatus();
		}
	}
	
	
	void handleMouseUp(int screenX, int screenY) {
		state = NORMAL;
	}


	protected void showStatus() {
		Info.showStatus("Location = (" + x + "," + y + "), width=" + width + ", height=" + height);
	}
	
	
	public int[] getMask() {
		return null;
	}

}
