package spec.benchmarks._239_nih; 
// Oval region of interest

import java.awt.*;
import java.awt.image.*;

class OvalRoi extends Roi {

	OvalRoi(int x, int y, ImagePlus imp) {
		super(x, y, imp);
		type = OVAL;
	}


	public void draw(Graphics g) {
		g.setColor(Color.yellow);
		g.drawOval(imp.screenX(x), imp.screenY(y), (int)(width*imp.getMagnification()), (int)(height*imp.getMagnification()));
		showStatus();
	}


	public boolean contains(int x, int y) {
	// equation for an ellipse is x^2/a^2 + y^2/b^2 = 1
		if (!super.contains(x, y))
			return false;
		else {
			x = Math.abs(x - (this.x + width/2));
			y = Math.abs(y - (this.y + height/2));
			double a = width/2;
			double b = height/2;
			return (x*x/(a*a) + y*y/(b*b)) <= 1;
		}
	}
	
	
	public int[] getMask() {
		Image img = imp.getImageJ().createImage(width, height);
		Graphics g = img.getGraphics();
		g.setColor(Color.black);
		g.fillOval(0, 0, width, height);
		ColorProcessor cp = new ColorProcessor(img);
		return (int[])cp.getPixels();
	}

}