package spec.benchmarks._239_nih; 
// Displays a multi-line message in a modal dialog box.

import java.awt.*;

public class MessageWithCancelDialog extends Dialog {
    private Button cancel, okay;
    private MultiLineLabel label;

    public MessageWithCancelDialog(Frame parent, String title, String message) {
        super(parent, title, true);
	    label = new MultiLineLabel(message);
		label.setFont(new Font("Dialog", Font.PLAIN, 12));
        add("Center", label);
        cancel = new Button(" Cancel ");
        okay = new Button("  OK  ");
        Panel p = new Panel();
        p.add(cancel);
        p.add(okay);
        add("South", p);
        pack();
		Rectangle pBounds = parent.bounds();
		move(pBounds.x+60, pBounds.y+60);
        show();
    }
    

	private void close(boolean ok) {
		hide();
		dispose();
		if (ok)
			Info.ModalDialogState = Info.OKAY;
		else
			Info.ModalDialogState = Info.CANCEL;
	}
	
	
	public boolean action(Event event, Object arg) {
		if (event.target==okay)
			close(true);
		else if (event.target==cancel)
			close(false);
		return true;
	}


	public boolean keyDown(Event event, int key) {
		if (Info.debugMode) Info.write("key: " + key);
		if (key == 13 || key == 10) // CR or LF
			close(true);
		return true;
	}


	public boolean gotFocus(Event event, Object arg) {
		if (Info.debugMode) Info.write("gotFocus");
		okay.requestFocus();
		return true;
	}

	public boolean mouseDown(Event e, int x, int y) {
		if (Info.debugMode) Info.write("mouseDown: " + x + " " + y);
		if (Info.debugMode && e.target==cancel) Info.write("  target=cancel");
		if (e.target==cancel) // work-around for Netscape bug
			close(false);
		return true;
	}
}