package spec.benchmarks._239_nih; 
// Displays a message in a modal dialog box. Based on the InfoDialog
// class from "Java in a Nutshell" by David Flanagan

import java.awt.*;

public class MessageDialog extends Dialog {
    protected Button button;
    protected MultiLineLabel label;

    public MessageDialog(Frame parent, String title, String message) {
        super(parent, title, true);
        setLayout(new BorderLayout());
	    label = new MultiLineLabel(message);
		label.setFont(new Font("Dialog", Font.PLAIN, 12));
        add("Center", label);
        button = new Button("  OK  ");
        Panel p = new Panel();
        p.setLayout(new FlowLayout());
        p.add(button);
        add("South", p);
        pack();
		Rectangle pBounds = parent.bounds();
		move(pBounds.x+60, pBounds.y+60);
        show();
    }
    

	public boolean handleEvent(Event event) {
		switch(event.id) {
			case Event.ACTION_EVENT:
			case Event.KEY_PRESS:
			case Event.WINDOW_DESTROY:
				this.hide();
				this.dispose();
				break;
			case Event.GOT_FOCUS:
				button.requestFocus();
				break;
			default:
				break;
			}
		return true;
	}


}