package spec.benchmarks._239_nih; 
import java.awt.*;

class Menus {
	static MenuBar mbar;
	static Menu file;
		static Menu open;
		static Menu saveAs;
	static Menu edit;
	static Menu image;
		static Menu imageType;
			static CheckboxMenuItem gray8Item;
			static CheckboxMenuItem gray16Item;
			static CheckboxMenuItem gray32Item;
			static CheckboxMenuItem color256Item;
			static CheckboxMenuItem colorRGBItem;
			static CheckboxMenuItem RGBAItem;
			static CheckboxMenuItem HSBItem;
		static Menu channel;
		static Menu flip;
	static Menu process;
	static Menu analyze;
	static Menu plugIns;
		static CheckboxMenuItem debugMenuItem;
	static Menu help;
	
	static final String gif0 = "Logo [3K]";
	static final String gif1 = "Ceretec Sagittals [12K]";
	static final String gif11 = "Enhance Me [25K]";
	static final String gif2 = "Cat [29K]";
	static final String gif3 = "Color Lena [18K]";
	static final String gif4 = "Little Girl [42K]";
	static final String gif5 = "Lena [47K]";
	static final String gif6 = "MRI Scan [48K]";
	static final String gif7 = "Face [64K]";
	static final String gif8 = "Baboon [70K]";
	
	static void addMenuBar(Frame ij) {
		mbar = new MenuBar();
		ij.setMenuBar(mbar);
		
		file = new Menu("File");
		file.add(new MenuItem("New"));
		file.add(new MenuItem("Open..."));
		open = new Menu("Open");
			open.add(new MenuItem(gif0));
			open.add(new MenuItem(gif1));
			open.add(new MenuItem(gif11));
			open.add(new MenuItem(gif2));
			open.add(new MenuItem(gif3));
			open.add(new MenuItem(gif4));
			open.add(new MenuItem(gif5));
			open.add(new MenuItem(gif6));
			open.add(new MenuItem(gif7));
			open.add(new MenuItem(gif8));
			file.add(open);
		file.add(new MenuItem("Import..."));
		file.add(new MenuItem("-"));
		file.add(new MenuItem("Close"));
		file.add(new MenuItem("Save"));
		saveAs = new Menu("Save As");
			saveAs.add(new MenuItem("Tiff..."));
			saveAs.add(new MenuItem("Gif..."));
			saveAs.add(new MenuItem("Raw Data..."));
			file.add(saveAs);
		file.add(new MenuItem("Revert"));
		file.add(new MenuItem("-"));
		file.add(new MenuItem("Quit"));
		mbar.add(file);
		
		edit = new Menu("Edit");
		edit.add(new MenuItem("Undo"));
		edit.add(new MenuItem("-"));
		edit.add(new MenuItem("Cut"));
		edit.add(new MenuItem("Copy"));
		edit.add(new MenuItem("Paste"));
		edit.add(new MenuItem("Clear"));
		edit.add(new MenuItem("-"));
		edit.add(new MenuItem("Fill"));
		edit.add(new MenuItem("Invert"));
		edit.add(new MenuItem("-"));
		debugMenuItem = new CheckboxMenuItem("Debug Mode");
		edit.add(debugMenuItem);
		debugMenuItem.setState(false);
		mbar.add(edit);
		
		image = new Menu("Image");
		imageType = new Menu("Type");
			gray8Item = new CheckboxMenuItem("8-bit Grayscale");
			imageType.add(gray8Item);
			gray8Item.setState(false);
			gray16Item = new CheckboxMenuItem("16-bit Grayscale");
			imageType.add(gray16Item);
			gray16Item.setState(false);
			gray32Item = new CheckboxMenuItem("32-bit Grayscale");
			imageType.add(gray32Item);
			gray32Item.setState(false);
			imageType.add(new MenuItem("-"));
			
			color256Item = new CheckboxMenuItem("8-bit Color");
			imageType.add(color256Item);
			color256Item.setState(false);
			colorRGBItem = new CheckboxMenuItem("RGB Color");
			imageType.add(colorRGBItem);
			colorRGBItem.setState(false);
			imageType.add(new MenuItem("-"));
			
			RGBAItem = new CheckboxMenuItem("RGBA");
			imageType.add(RGBAItem);
			RGBAItem.setState(false);
			HSBItem = new CheckboxMenuItem("HSB");
			imageType.add(HSBItem);
			HSBItem.setState(false);
			image.add(imageType);
			
		channel = new Menu("Channel");
			image.add(channel);
		image.add(new MenuItem("-"));
		image.add(new MenuItem("Duplicate"));
		image.add(new MenuItem("Get Info..."));
		image.add(new MenuItem("-"));
		image.add(new MenuItem("Scale..."));
		image.add(new MenuItem("Rotate..."));
			flip = new Menu("Flip");
			flip.add(new MenuItem("Vertical"));
			flip.add(new MenuItem("Horizontal"));
			image.add(flip);
		mbar.add(image);

		process = new Menu("Process");
		process.add(new MenuItem("Smooth"));
		process.add(new MenuItem("Sharpen"));
		process.add(new MenuItem("Find Edges"));
		process.add(new MenuItem("Add Noise"));
		process.add(new MenuItem("Enhance Contrast"));
		process.add(new MenuItem("Reduce Noise"));
		process.add(new MenuItem("-"));
		process.add(new MenuItem("Math..."));
		process.add(new MenuItem("Threshold"));
		mbar.add(process);
		
		analyze = new Menu("Analyze");
		analyze.add(new MenuItem("Histogram"));
		analyze.add(new MenuItem("Show Map"));
		analyze.add(new MenuItem("Plot Profile"));
		mbar.add(analyze);

		plugIns = new Menu("Plug-Ins");
		mbar.add(plugIns);

		help = new Menu("Help");
		help.add(new MenuItem("About..."));
		mbar.add(help);
	}
	
	
	static void updateMenus() {
	
		//Update Image/Type submenu
		gray8Item.setState(false);
		gray16Item.setState(false);
		gray32Item.setState(false);
		color256Item.setState(false);
		colorRGBItem.setState(false);
		RGBAItem.setState(false);
		HSBItem.setState(false);
		ImagePlus imp = WindowManager.getCurrentImage();
		if (imp==null)
			return;
    	int type = imp.getType();
    	switch (type) {
    		case ImagePlus.GRAY8:
				gray8Item.setState(true);
				break;
     		case ImagePlus.GRAY16:
				gray16Item.setState(true);
				break;
     		case ImagePlus.GRAY32:
				gray32Item.setState(true);
				break;
   			case ImagePlus.COLOR_256:
				color256Item.setState(true);
				break;
    		case ImagePlus.COLOR_RGB:
				colorRGBItem.setState(true);
				break;
    		case ImagePlus.RGBA:
				RGBAItem.setState(true);
				break;
    		case ImagePlus.HSB:
				HSBItem.setState(true);
				break;
		}
		
		//Update Image/Channel submenu
    	int nItems = channel.countItems();
    	CheckboxMenuItem item;
    	int stackSize = imp.getDepth();
    	int nChannels = 0;
    	Stack stack = null;
    	if (stackSize > 1) {
			stack = imp.getStack();
    		nChannels = stackSize;
    	}
    	if (nChannels!=nItems) {
			for (int i=0; i<nItems; i++) //remove all items
				channel.remove(0);
			for (int i=1; i<=nChannels; i++) {
				channel.add(new CheckboxMenuItem(stack.getTitle(i)));
				item = (CheckboxMenuItem)channel.getItem(i-1);
				item.setState(i==stack.getCurrentSlice());
			}
    	}
	}
	

	static boolean isChannelEvent(String item, ImagePlus imp) {
    	int nItems = channel.countItems();
    	CheckboxMenuItem menuItem, cbi;
    	boolean isMatch = false;
    	
		if (imp.getDepth()==1)
			return false;
		Stack stack = imp.getStack();
    	for (int i=0; i<nItems; i++) {
			menuItem = (CheckboxMenuItem)channel.getItem(i);
			if (menuItem.paramString().indexOf(item) >= 0) {
				isMatch |= true;
				stack.setSlice(i+1);
    			for (int j=0; j<nItems; j++) {
					cbi = (CheckboxMenuItem)channel.getItem(j);
    				cbi.setState(false);
    			}
				menuItem.setState(true);
			}
			//System.out.println(item + "  " + menuItem.paramString());
    	}
    	return isMatch;
	}
	
	
	static void installPlugIns (String[] list) {
		for (int i=0; i<list.length; i++) {
				plugIns.add(new MenuItem(list[i]));
		}
	}

}