package spec.benchmarks._239_nih; 
// Image/J plug-in that tries to find out how much memory is available for opening images

import java.awt.*;
import java.awt.image.*;
import java.util.Vector;

class Memory_Test implements PlugIn {


	public void run(ImagePlus imp) {
	
		boolean okay = Info.showMessageWithCancel("Memory Test", 
			"The Memory_Test plug-in opens as many\n"
			+ "1024x1024x8-bit images as possible and then\n"
			+ "calculates how much memory was used for each\n"
			+ "image. This is a demanding test that may require\n"
			+ "Image/J to be restarted, may crash your browser, \n"
			+ "or may even crash your machine."
			);
		if (!okay)
			return;

		int width = 1024;
		int arraySize = 1024*1024;
		Vector objects;
		int nArrays = 0;
		int nImages = 0;
		byte[] pixels;
		ColorModel cm;
		Image img, saveImg=null;

		Info.write("");
		Info.write("Opening " + width + "x" + width + " 8-bit image windows...");
		collectGarbage();
		try {
			while(true) {
				Info.getImageJ().newImageWindow(""+(nImages+1), width, width);
				nImages++;
			}
		}
		catch(OutOfMemoryError ex) {
			Info.write("Closing windows...");
			WindowManager.closeAllWindows();
			//Info.write("getWindowCount: " + WindowManager.getWindowCount());
			//Info.write((WindowManager.getCurrentWindow()==null?"currentWindow==null":"currentWindow!=null"));
			collectGarbage();
		}

		Info.wait(100);
		objects = new Vector();
		Info.write("Probing memory...");
		try {
			while(true) {
				System.gc();
				byte[] a = new byte[arraySize];
				objects.addElement(a);
				nArrays++;
				Info.showStatus((nArrays*arraySize)/(1024*1024) + "MB");
				Info.wait(50);
			}
		}
		catch(OutOfMemoryError e) {
			objects = null;
			collectGarbage();
			Info.write(arraySize*nArrays/(1024*1024) + "MB is available");
			Info.write(nImages + " images were opened");
			if (nImages>0)
				Info.write("~" + arraySize*nArrays/(nImages*1024) + "K was required for each image");
			Info.showStatus("");
		}

	}

	void collectGarbage() {
		for (int i=0; i<10; i++)
			System.gc();
	}

}
