package spec.benchmarks._239_nih; 
public class Macro2 implements PlugIn {
	
	public void run(ImagePlus imp) {
		if (imp==null) {Info.noImage(); return;}  // Exit if no image
		imp.reserve(); 
		ImageProcessor ip = imp.getProcessor();
		ip.snapshot();

		double scale = 0.85;
		int angle = 10;
		for (int i=0; i <17; i++) {
			ip.reset();
			ip.scale(scale, scale, false);
			ip.rotate(angle);
			imp.updateAndDraw();
			scale *= 0.85;
			angle += 10;
		}
		for (int i=0; i <18; i++) {
			ip.reset();
			ip.scale(scale, scale, false);
			ip.rotate(angle);
			imp.updateAndDraw();
			scale /= 0.85;
			angle += 10;
		}
		ip.reset();
		imp.updateAndDraw();
		imp.unreserve(); 
	}

}
