package spec.benchmarks._239_nih; 
public class Macro1 implements PlugIn {
	
	public void run(ImagePlus imp) {
		int x, y;
		int dstWidth, dstHeight;
		double factor = 2.0;
		
		if (imp==null) {
			Info.noImage();
			return;
		}
		imp.reserve(); 
		ImageProcessor ip = imp.getProcessor();
		ip.snapshot();
		ImageJ ij = imp.getImageJ();
		ImagePlus imp2;
		ImageProcessor ip2;
		
		dstWidth = ip.getWidth();
		dstHeight = ip.getHeight();
		for (int i=0; i<7; i++) {
			imp2 = new ImagePlus("", imp.getImage(), ij);
			ip2 = imp2.getProcessor();
			ip2.scale(1/factor, 1/factor, true);
			x = 0; y = 0;
			do {
				ip.insert(ip2, x, y);
				x += dstWidth/factor;
				if (x >= dstWidth) {
					x = 0;
					y += dstHeight/factor;
				}
			} while (y<dstHeight);
			imp.updateAndDraw();
		}
		ip.reset();
		imp.unreserve(); 
	}

}
