package spec.benchmarks._239_nih; 
// Import dialog box

import java.awt.*;
import java.awt.image.*;
import java.io.*;

public class ImportDialog extends Dialog {
    private ImageJ ij;
    private String fileName;
    private String directory;
    private Choice choice;
    private TextField widthField, heightField, offsetField, nImagesField;
    private Label widthLabel, heightLabel, offsetLabel, nImagesLabel;
    private Checkbox blackIsZeroCB;
    private Checkbox swapBytesCB;
    private static boolean blackIsZero = false;
    private static boolean swapBytes = false;
    private Button cancel, okay;
    private static int width=512, height=512, offset=0, nImages=1;
	private GridBagConstraints c;
	
    public ImportDialog(ImageJ ij, String fileName, String directory) {
        super((Frame)ij, "Import...", true);
        this.ij = ij;
        this.fileName = fileName;
        this.directory = directory;
		Info.showStatus("Importing: " + fileName);

		GridBagLayout grid = new GridBagLayout();
		c = new GridBagConstraints();
		setLayout(grid);
		
		setGridLoc(0, 0);
		choice = new Choice();
		choice.addItem("8-bit");
		choice.addItem("16-bit");
		choice.addItem("32-bit Integer");
		choice.addItem("32-bit Real");
		choice.addItem("24-bit RGB Color");
		choice.addItem("24-bit RGB Color (planar)");
		c.gridwidth = 2;
		c.anchor = GridBagConstraints.CENTER;
		c.insets = new Insets(0, 0, 15, 0);
		grid.setConstraints(choice, c);
		add(choice);

		setGridLoc(1, 0);
		widthLabel = new Label("Image Width:");
		c.anchor = c.EAST;
		c.gridwidth = 1;
		c.insets = new Insets(0, 0, 5, 0);
		grid.setConstraints(widthLabel, c);
		add(widthLabel);

		setGridLoc(1, 1);
		widthField = new TextField(""+width, 5);
		c.anchor = c.WEST;
		grid.setConstraints(widthField, c);
		widthField.setEditable(true);
		widthField.selectAll();
		add(widthField);

		setGridLoc(2, 0);
		heightLabel = new Label("Image Height:");
		c.anchor = c.EAST;
		grid.setConstraints(heightLabel, c);
		add(heightLabel);

		setGridLoc(2, 1);
		heightField = new TextField(""+height, 5);
		c.anchor = c.WEST;
		grid.setConstraints(heightField, c);
		heightField.setEditable(true);
		heightField.selectAll();
		add(heightField);

		setGridLoc(3, 0);
		offsetLabel = new Label("Offset to First Image:");
		c.anchor = c.EAST;
		grid.setConstraints(offsetLabel, c);
		add(offsetLabel);

		setGridLoc(3, 1);
		offsetField = new TextField(""+offset, 5);
		c.anchor = c.WEST;
		grid.setConstraints(offsetField, c);
		offsetField.setEditable(true);
		offsetField.selectAll();
		add(offsetField);

		setGridLoc(4, 0);
		nImagesLabel = new Label("Number of Images:");
		c.anchor = c.EAST;
		grid.setConstraints(nImagesLabel, c);
		add(nImagesLabel);

		setGridLoc(4, 1);
		nImagesField = new TextField(""+nImages, 5);
		c.anchor = c.WEST;
		grid.setConstraints(nImagesField, c);
		nImagesField.setEditable(true);
		nImagesField.selectAll();
		add(nImagesField);

		setGridLoc(5, 0);
		blackIsZeroCB = new Checkbox("Black is Zero");
		c.gridwidth = 2;
		c.insets = new Insets(10, 30, 5, 0);
		c.anchor = GridBagConstraints.WEST;
		grid.setConstraints(blackIsZeroCB, c);
		blackIsZeroCB.setState(blackIsZero);
		add(blackIsZeroCB);
		
		setGridLoc(6, 0);
		swapBytesCB = new Checkbox("Swap Bytes");
		c.gridwidth = 2;
		c.insets = new Insets(0, 30, 10, 0);
		c.anchor = GridBagConstraints.WEST;
		grid.setConstraints(swapBytesCB, c);
		swapBytesCB.setState(swapBytes);
		add(swapBytesCB);
		
		setGridLoc(7, 0);
		cancel = new Button("Cancel");
		c.gridwidth = 1;
		c.insets = new Insets(10, 3, 15, 3);
		c.anchor = GridBagConstraints.EAST;
		grid.setConstraints(cancel, c);
		add(cancel);
		
		setGridLoc(7, 1);
		okay = new Button("  OK  ");
		c.anchor = GridBagConstraints.WEST;
		grid.setConstraints(okay, c);
		add(okay);
		
		pack();
		Rectangle ijBounds = ij.bounds();
		move(ijBounds.x+40, ijBounds.y+40);
		show();
    }
    

	void setGridLoc(int row, int column) {
		c.gridy = row;
		c.gridx = column;
	}


	int getInt(TextField field, int defaultValue) {
		Double d;
		try {d = new Double(field.getText());}
		catch (NumberFormatException e) {
			field.setText(""+defaultValue);
			d = null;
		}
		return (d!=null)?(int)d.doubleValue():defaultValue;
	}


	void readImage() {
		FileInputStream in;
						
		String path = directory + fileName;
		File f = new File(path);
		String imageType = choice.getSelectedItem();
		width = getInt(widthField, width);;
		height = getInt(heightField, height);
		offset = getInt(offsetField, offset);
		swapBytes = swapBytesCB.getState();
		blackIsZero = blackIsZeroCB.getState();
		
		FileInfo fi = new FileInfo();
		fi.fileName = fileName;
		fi.width = width;
		fi.height = height;
		fi.offset = offset;
		fi.swapBytes = swapBytes;
		fi.blackIsZero = blackIsZero;
		fi.ij = ij;
		if (imageType.equals("8-bit")) {
			fi.fileType = FileInfo.GRAY8;
		}
		else if (imageType.equals("16-bit")) {
			fi.fileType = FileInfo.GRAY16;
		}
		else if (imageType.equals("32-bit Integer")) {
			fi.fileType = FileInfo.GRAY32_INT;
		}
		else if (imageType.equals("32-bit Real")) {
			fi.fileType = FileInfo.GRAY32_FLOAT;
		}
		else if (imageType.equals("24-bit RGB Color")) {
			fi.fileType = FileInfo.RGB;
		}
		else if (imageType.equals("24-bit RGB Color (planar)")) {
			fi.fileType = FileInfo.RGB_PLANAR;
		}
		else
			return;
			
		try {
			in = new FileInputStream(f);
			ImageReader file = new ImageReader(fi);
			file.openImage(in);
			in.close();
		}
		catch (IOException e) {
			Info.write("" + e);
			return;
		}
	}
	

	public boolean action(Event event, Object arg) {

		if (event.target==okay) {
			readImage();
			hide();
			dispose();
            return true;
		}
		
		if (event.target==cancel) {
			hide();
			dispose();
            return true;
		}
		
		return super.action(event, arg);
	}


	public boolean keyDown(Event event, int key) {
		if (key == 13 || key == 10) {// CR or LF
			readImage();
			hide();
			dispose();
		}
		return super.keyDown(event, key);
	}


    public Insets insets() {
    	return new Insets(30, 30, 20, 30);
    }

}