package spec.benchmarks._239_nih; 
// Histogram of an image or image roi

import java.awt.*;

class ImageStatistics {

	int[] histogram;
	int nBins = 256;
	double binSize = 1;
	double histMin = 0.0;
	double histMax = 256.0;
	double min, max;
	int pixelCount;
	int maxCount;
	int mode;
	double mean;
	double stdDev;
	
	protected int width, height;
	protected int roiX, roiY, roiWidth, roiHeight;

	
	void getMinAndMax() {
		int min = 0;
		while ((histogram[min] == 0) && (min < 255))
			min++;
		this.min = min;
			
		int max = 255;
		while ((histogram[max] == 0) && (max > 0))
			max--;
		this.max = max;
	}


	void getStatistics() {
        int count;
        double sum = 0;
		
		binSize = (histMax - histMin)/nBins;
        for (int i = 0; i < nBins; i++) {
        	count = histogram[i];
        	pixelCount += count;
			sum += (histMin+i*binSize) * count;
            if (count > maxCount) {
                maxCount = count;
                mode = i;
            }
        }
		mean = sum / pixelCount;
	}
	

	void setRoiLimits(Rectangle roi) {
		if (roi != null) {
			roiX = roi.x;
			roiY = roi.y;
			roiWidth = roi.width;
			roiHeight = roi.height;
		}
		else {
			roiX = 0;
			roiY = 0;
			roiWidth = width;
			roiHeight = height;
		}
	}
	
}