package spec.benchmarks._239_nih; 
// An Image/J Plug-In that demonstrates the use of the ImageProcessor class.

import java.awt.*;

public class IP_Demo extends Frame implements PlugIn {

	ImagePlus imp;
	ImageProcessor ip = null;
	ImageJ ij;
	boolean invertedLut;

	IP_Demo() {
		setLayout(new BorderLayout());
		Panel p = new Panel();
		p.setLayout(new GridLayout(5, 3));
		p.add(new Button("Reset"));
		p.add(new Button("Flip"));
		p.add(new Button("Invert"));
		p.add(new Button("Lighten"));
		p.add(new Button("Darken"));
		p.add(new Button("Rotate"));
		p.add(new Button("Zoom In"));
		p.add(new Button("Zoom Out"));
		p.add(new Button("Threshsold"));
		p.add(new Button("Smooth"));
		p.add(new Button("Sharpen"));
		p.add(new Button("Find Edges"));
		p.add(new Button("Macro"));
		p.add(new Button("Add Noise"));
		p.add(new Button("Done"));
		add("South", p);
		pack();
		show();
	}
	
	
	public void run(ImagePlus imp) {
		if (imp==null) {
			hide();
			dispose();
			Info.noImage();
			return;
		}
		this.imp = imp;
		imp.reserve(); 
		ip = imp.getProcessor();
	 	ip.snapshot();
		ij = imp.getImageJ();
		setTitle("IPDemo: " + imp.getTitle());
		LookUpTable lut = imp.getLUT();
		if (lut!=null)
			invertedLut = lut.isInverted();
		else
			invertedLut = false;
		
	}


	public void update(Graphics g) {
		paint(g);
	}

	public void paint(Graphics g) {
		imp.updateAndDraw();
	}

	public boolean action(Event e, Object arg) {
	
		//ij.write("action: " + e);

		if (e.target instanceof Button) {
			String label = (String)arg;
			if (label.equals("Reset"))
				ip.reset();
			else if (label.equals("Flip"))
				ip.flipVertical();
			else if (label.equals("Invert"))
				ip.invert();
			else if (label.equals("Lighten")) {
				if (invertedLut)
					ip.multiply(0.9);
				else
					ip.multiply(1.1);
			}
			else if (label.equals("Darken")) {
				if (invertedLut)
					ip.multiply(1.1);
				else
					ip.multiply(0.9);
			}
			else if (label.equals("Rotate"))
				ip.rotate(30);
			else if (label.equals("Zoom In"))
				ip.scale(1.2, 1.2, false);
			else if (label.equals("Zoom Out"))
				ip.scale(.8, .8, false);
			else if (label.equals("Threshsold"))
				ip.autoThreshold();
			else if (label.equals("Smooth"))
				ip.smooth();
			else if (label.equals("Sharpen"))
				ip.sharpen();
			else if (label.equals("Find Edges"))
				ip.findEdges();
			else if (label.equals("Macro"))
				macro();
			else if (label.equals("Add Noise"))
				ip.noise(20);
			else if (label.equals("Done")) {
				imp.unreserve(); 
				hide();
				dispose();
				return true;
			}
			Roi roi = imp.getRoi();
			if (roi!=null) {
				int[] mask = roi.getMask();
				if (mask!=null)
					ip.reset(mask);
			}
			repaint();
			return true;
		}
		return false;
	}
	
	void macro() {
		for (int i=10; i<=360; i+=10) {
			ip.reset();
			ip.rotate(i);
			imp.updateAndDraw();
		}
	}
	
	
}