package spec.benchmarks._239_nih; 
// This modal dialog box allows the user to enter a number

import java.awt.*;

public class GetNumberDialog extends Dialog {
    private TextField field;
    private Label label;
    private Button cancel, okay;
    private ImageJ ij;
    private ImagePlus imp;
    private int defaultCount;

    public GetNumberDialog(ImageJ ij, ImagePlus imp, String prompt, int defaultCount) {
        super((Frame)ij, "Convert to Indexed Color", true);
        this.ij = ij;
        this.imp = imp;
        this.defaultCount = defaultCount;
		GridBagLayout grid = new GridBagLayout();
		GridBagConstraints c = new GridBagConstraints();
		setLayout(grid);
		
		label = new Label(prompt);
		c.gridx = 0; c.gridy = 0;
		c.insets = new Insets(0, 0, 5, 0);
		grid.setConstraints(label, c);
		add(label);

		field = new TextField(""+defaultCount, 5);
		c.gridx = 1; c.gridy = 0;
		grid.setConstraints(field, c);
		field.setEditable(true);
		field.selectAll();
		add(field);

		cancel = new Button("Cancel");
		c.gridx = 0; c.gridy = 1;
		c.gridwidth = 1;
		c.insets = new Insets(20, 3, 15, 3);
		c.anchor = GridBagConstraints.EAST;
		grid.setConstraints(cancel, c);
		add(cancel);
		
		okay = new Button("  OK  ");
		c.gridx = 1; c.gridy = 1;
		c.anchor = GridBagConstraints.WEST;
		grid.setConstraints(okay, c);
		add(okay);
		
		pack();
		Rectangle pBounds = ij.bounds();
		move(pBounds.x+60, pBounds.y+60);
		show();
    }
    

	void convert() {
		int width, height;
		int[] pixels;
		ImageProcessor ip;
		MedianCut mc;
		Double d;
		int nColors=256;
		
		// get color count
		try {d = new Double(field.getText());}
		catch (NumberFormatException e){
			field.setText(""+defaultCount);
			d = null;
		}
		if (d!=null)
			nColors = (int)d.doubleValue();

		// get RGB pixels
		Info.showProgress(0.1);
		ij.showStatus("Grabbing pixels");
		width = imp.getWidth();
		height = imp.getHeight();
		ip = imp.getProcessor();
	 	ip.snapshot();
		pixels = (int[])ip.getPixels();
		imp.killProcessor();
		
		// convert to 8-bits
		long start = System.currentTimeMillis();
		mc = new MedianCut(pixels, width, height, ij);
		Image img8 = mc.convert(nColors);
	    Undo.setup(Undo.TYPE_CONVERSION, imp);
	    imp.setImage(img8);
		imp.draw();
		//ij.write("Color count: " + mc.getColorCount());
		Info.showTime(imp, start, "");
		hide();
		dispose();
		Info.showProgress(1.0);
	}
	

	public boolean action(Event event, Object arg) {
        if (event.target==field)
        	field.setText((String)arg);
		else if (event.target==okay)
			convert();
		else if (event.target==cancel)
			{hide(); dispose();}
		return true;
	}


	public boolean keyDown(Event event, int key) {
		if (key == 13 || key == 10) { // CR or LF
			convert();
			return true;
		}
		else
			return false;
	}

    
    public Insets insets() {
    	return new Insets(40, 20, 20, 20);
    }

}