package spec.benchmarks._239_nih; 
// Freehand region of interest

import java.awt.*;
import java.awt.image.*;

class FreehandRoi extends PolygonRoi {


	FreehandRoi(int x, int y, ImagePlus imp) {
		super(x, y, imp);
		type = FREEHAND;
	}


	protected void grow(int xNew, int yNew) {
		if (nPoints>=(MAX_POINTS-1))
			return;
		int sx = imp.screenX(xNew);
		int sy = imp.screenY(yNew);
		if  (sx!=xp2[nPoints-1] || sy!=yp2[nPoints-1]) {
			xp2[nPoints] = sx;
			yp2[nPoints] = sy;
			nPoints++;
			g.setColor(Color.yellow);
			g.drawLine(xp2[nPoints-2], yp2[nPoints-2], imp.screenX(xNew), imp.screenY(yNew));
		}
	}


	void handleMouseUp(int screenX, int screenY) {
		if (state==CONSTRUCTING)
			finishPolygon();
		state = NORMAL;
	}

}