package spec.benchmarks._239_nih; 
// 32-bit image statistics, including histogram

import java.awt.*;

class FloatStatistics extends ImageStatistics {

	FloatStatistics(ImageProcessor ip) {
		this.width = ip.getWidth();
		this.height = ip.getHeight();
		setRoiLimits(ip.getRoi());
		FloatProcessor fp = (FloatProcessor)ip;
		min = fp.getMin();
		max = fp.getMax();
		histMin = min;
		histMax = max;
		getHistogram(ip);
		getMode();
	}


	void getHistogram(ImageProcessor ip) {
		float v;
		float[] pixels = (float[])ip.getPixels();
		histogram = new int[nBins];
		float scale = (float)((nBins-1)/(histMax-histMin));
		binSize = (histMax - histMin)/nBins;
		float sum = 0;
		float roiMin = Float.MAX_VALUE;
		float roiMax = Float.MIN_VALUE;
		boolean isRoi = roiX!=0;
		
		for (int y=roiY; y<(roiY+roiHeight); y++) {
			int i = y * width + roiX;
			for (int x=roiX; x<(roiX+roiWidth); x++) {
				v = pixels[i++];
				histogram[(int)(scale*(v-histMin))]++;
				sum += v;
				if (isRoi) {  //if not, get min and max from FloatProcessor
					if (v<roiMin) roiMin = v;
					if (v>roiMax) roiMax = v;
				}
			}
		}
		pixelCount = roiWidth*roiHeight;
		mean = (double)sum/pixelCount;
		if (isRoi) {
			min = roiMin;
			max = roiMax;
		}
	}
	

	void getMode() {
        int count;
        maxCount = 0;
        for (int i = 0; i < nBins; i++) {
        	count = histogram[i];
            if (count > maxCount) {
                maxCount = count;
                mode = i;
            }
        }
	}

}