package spec.benchmarks._239_nih; 
// Processes 32-bit real images.

import java.util.*;
import java.awt.*;
import java.awt.image.*;

class FloatProcessor extends ImageProcessor {

	private float min, max, snapshotMin, snapshotMax;
	private float[] pixels;
	private float[] snapshotPixels = null;
	private boolean invert = false;
	private byte[] LUT = null;
	private float fgColor =  Float.MAX_VALUE;
	private float bgColor = Float.MIN_VALUE;
	private ColorModel cm;


	FloatProcessor(float[] pixels, int width, int height, ColorModel cm, ProgressBar bar) {
		this.width = width;
		this.height = height;
		this.pixels = pixels;
		this.cm = cm;
		setRoi(null);
		progressBar = bar;
		findMinAndMax();
	}


	void findMinAndMax() {
		min = Float.MAX_VALUE;
		max = -Float.MAX_VALUE;
		for (int i=0; i < width*height; i++) {
			float value = pixels[i];
			if (value<min)
				min = value;
			if (value>max)
				max = value;
		}
		pixelsModified = true;
		hideProgress();
	}


	Image createImage() {
		byte[] pixels8 = new byte[width*height];
		Image img;
				
		float scale = 255f/(max-min);
		for (int i=0; i < width*height; i++)
			pixels8[i] = (byte)((int)(scale*(pixels[i]-min))&0xff);
	    img = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(width, height, cm, pixels8, 0, width));
        return img;
	}
	

	Image createImage(Rectangle srcRect, int dstWidth, int dstHeight) {return null;}


	void snapshot() {
	//Make a snapshot of the current image
		snapshotWidth=width;
		snapshotHeight=height;
		snapshotMin=min;
		snapshotMax=max;
		if (snapshotPixels==null || (snapshotPixels!=null && snapshotPixels.length!=pixels.length))
			snapshotPixels = new float[width * height];
        System.arraycopy(pixels, 0, snapshotPixels, 0, width*height);
        pixelsModified = false;
	}
	

	void reset() {
	//Reset the image from snapshot
		if (snapshotPixels!=null) {
			pixelsModified = width!=snapshotWidth || height!=snapshotHeight;
		    width=snapshotWidth;
    		height=snapshotHeight;
		    min=snapshotMin;
    		max=snapshotMax;
    		pixels = new float[width * height];
            System.arraycopy(snapshotPixels,0,pixels,0,width*height);
    	}
	}
	

	void reset(int[] mask) {
	// Restore pixels that are within roi but not part of mask
		for (int y=roiY, my=0; y<(roiY+roiHeight); y++, my++) {
			int i = y * width + roiX;
			int mi = my * roiWidth;
			for (int x=roiX; x<(roiX+roiWidth); x++) {
				if (mask[mi++]==-1)
					pixels[i] = snapshotPixels[i];
				i++;
			}
		}
	}


	float getPixel(int x, int y) {
		if (x>=0 && x<width && y>=0 && y<height)
			return pixels[y*width + x];
		else
			return 0f;
	}


	float getMin() {
		return min;
	}


	float getMax() {
		return max;
	}


	Object getPixels() {
		return (Object)pixels;
	}


	void insert(ImageProcessor ip, int xloc, int yloc) {}
	
	
	void applyTable(byte[] lut) {}


	private float[] getCopyOfPixels() {
		if (pixelsModified) {
			float[] pixelsCopy = new float[width * height];
	        System.arraycopy(pixels, 0, pixelsCopy, 0, width*height);
			return pixelsCopy;
		}
		else
			return snapshotPixels;
	}
	
	
	private void process(int op, double value) {
		float SCALE = 255f/(float)Math.log(255.0);
		float c, v1, v2;
		
		c = (float)value;
		for (int y=roiY; y<(roiY+roiHeight); y++) {
			int i = y * width + roiX;
			for (int x=roiX; x<(roiX+roiWidth); x++) {
				v1 = pixels[i];
				switch(op) {
					case INVERT:
						v2 = max - (v1 - min);
						break;
					case CLEAR:
						v2 = min;
						break;
					case FILL:
						v2 = max;
						break;
					case ADD:
						v2 = v1 + c;
						break;
					case MULT:
						v2 = v1 * c;
						break;
					case GAMMA:
						v2 = (float)(Math.exp(c*Math.log(v1/255.0))*255.0);
						break;
					case LOG:
						if (v1==0f)
							v2 = 0f;
						else
							v2 = (float)Math.log(v1) * SCALE;
						break;
					 default:
					 	v2 = v1;
				}
				pixels[i++] = v2;
			}
			if (y%20==0)
				showProgress((double)(y-roiY)/roiHeight);
		}
		findMinAndMax();
    }


	void invert() {process(INVERT, 0.0);}
	void clear() {process(CLEAR, 0.0);}
	void fill() {process(FILL, 0.0);}

	void add(int value) {process(ADD, value);}
	void multiply(double value) {process(MULT, value);}
	void and(int value) {}
	void or(int value) {}
	void xor(int value) {}
	void gamma(double value) {process(GAMMA, value);}
	void log() {process(LOG, 0.0);}


	void smooth() {
		float[] pixels2;
		int i, x, y, offset, rowOffset;
		float p1, p2, p3, p4, p5, p6, p7, p8, p9;
	
		pixels2 = getCopyOfPixels();
        rowOffset = width;
		for (y = yMin; y <= yMax; y++) {
			offset = xMin + y * rowOffset + 1;
			p2 = pixels2[offset - width - 2];
			p3 = pixels2[offset - width - 1];
			p5 = pixels2[offset] - 2;
			p6 = pixels2[offset - 1];
			p8 = pixels2[offset + width - 2];
			p9 = pixels2[offset + width - 1];
			offset = xMin + y * rowOffset;
			for (x = xMin; x <= xMax; x++) {
				p1 = p2;
				p2 = p3;
				p3 = pixels2[offset - rowOffset + 1];
				p4 = p5;
				p5 = p6;
				p6 = pixels2[offset + 1];
				p7 = p8;
				p8 = p9;
				p9 = pixels2[offset + rowOffset + 1];
				pixels[offset++] = (p1 + p2 + p3 + p4 + p5 + p6 + p7 + p8 + p9)/9;
			}
			if (y%20==0)
				showProgress((double)(y-roiY)/roiHeight);
		}
		findMinAndMax();
	}
	

	void sharpen() {
		float[] pixels2;
		int i, x, y, offset, rowOffset;
		float p1, p2, p3, p4, p5, p6, p7, p8, p9;
	
		pixels2 = getCopyOfPixels();
        rowOffset = width;
		for (y = yMin; y <= yMax; y++) {
			offset = xMin + y * rowOffset + 1;
			p2 = pixels2[offset - width - 2];
			p3 = pixels2[offset - width - 1];
			p5 = pixels2[offset] - 2;
			p6 = pixels2[offset - 1];
			p8 = pixels2[offset + width - 2];
			p9 = pixels2[offset + width - 1];
			offset = xMin + y * rowOffset;
			for (x = xMin; x <= xMax; x++) {
				p1 = p2;
				p2 = p3;
				p3 = pixels2[offset - rowOffset + 1];
				p4 = p5;
				p5 = p6;
				p6 = pixels2[offset + 1];
				p7 = p8;
				p8 = p9;
				p9 = pixels2[offset + rowOffset + 1];
				pixels[offset++] =  (p5*12 - p1 - p2 - p3 - p4 - p6 - p7 - p8 - p9) / 4;
			}
			if (y%20==0)
				showProgress((double)(y-roiY)/roiHeight);
		}
		findMinAndMax();
	}
	

	void findEdges() {
		float[] pixels2;
		int i, x, y, offset, rowOffset;
		float sum1, sum2;
		float p1, p2, p3, p4, p5, p6, p7, p8, p9;
	
		pixels2 = getCopyOfPixels();
        rowOffset = width;
		for (y = yMin; y <= yMax; y++) {
			offset = xMin + y * rowOffset + 1;
			p2 = pixels2[offset - width - 2];
			p3 = pixels2[offset - width - 1];
			p5 = pixels2[offset] - 2;
			p6 = pixels2[offset - 1];
			p8 = pixels2[offset + width - 2];
			p9 = pixels2[offset + width - 1];
			offset = xMin + y * rowOffset;
			for (x = xMin; x <= xMax; x++) {
				p1 = p2;
				p2 = p3;
				p3 = pixels2[offset - rowOffset + 1];
				p4 = p5;
				p5 = p6;
				p6 = pixels2[offset + 1];
				p7 = p8;
				p8 = p9;
				p9 = pixels2[offset + rowOffset + 1];
	        	sum1 = p1 + 2*p2 + p3 - p7 -2*p8 - p9;
	        	sum2 = p1  + 2*p4 + p7 - p3 - 2*p6 - p9;
	        	pixels[offset++] = (int)Math.sqrt(sum1*sum1 + sum2*sum2);
			}
			if (y%20==0)
				showProgress((double)(y-roiY)/roiHeight);
		}
		findMinAndMax();
	}


    void noise(double range) {
		Random rnd=new Random();

		for (int y=roiY; y<(roiY+roiHeight); y++) {
			int i = y * width + roiX;
			for (int x=roiX; x<(roiX+roiWidth); x++) {
				float RandomBrightness = (float)(rnd.nextGaussian()*range);
				pixels[i] = pixels[i] + RandomBrightness;
				i++;
			}
			if (y%20==0)
				showProgress((double)(y-roiY)/roiHeight);
		}
		findMinAndMax();
    }


	public void crop() {}
	
	void scale(double xScale, double yScale, boolean resizeImage) {}

	void rotate(double angle) {}

	void flipVertical() {}

	void flipHorizontal() {}


	int[] getHistogram() {
		int[] histogram = new int[256];
		double scale = 256.0/(max-min+1);
		for (int i=0; i < width*height; i++)
			histogram[(int)(scale*(pixels[i]-min))&0xff]++;
		return histogram;
	}


	void threshold(int level) {}

	void autoThreshold() {}

	void enhanceContrast() {}

	void medianFilter() {}


}

