package spec.benchmarks._239_nih; 
// Describes an image file

class FileInfo {

	// File types
	static final int GRAY8 = 0;
	static final int GRAY16 = 1;
	static final int GRAY32_INT = 2;
	static final int GRAY32_FLOAT = 3;
	static final int COLOR8 = 4;
	static final int RGB = 5;
	static final int RGB_PLANAR = 6;

	public int fileType;
	public String fileName;
    public int width;
    public int height;
    public int offset=0;
    public int nImages;
    public boolean blackIsZero;
    public boolean swapBytes;
	public byte[] colorTable;
	public Object pixels;
    public ImageJ ij;
    
    FileInfo() {
    	// assign default values
    	fileType = GRAY8;
    	fileName = "Untitled";
	    width = 512;
	    height = 512;
	    offset = 0;
	    nImages = 1;
	    blackIsZero = false;
	    swapBytes = false;
	    colorTable = null;
	    pixels = null;
	    ij = null;
    }
}