package spec.benchmarks._239_nih; 
// This plug-in runs a simple image processing benchmark

class Benchmark implements PlugIn {
	

	public void run(ImagePlus imp) {
		if (imp==null) {
			Info.noImage();
			return;
		}
		imp.reserve(); 
		ImageProcessor ip = imp.getProcessor();
		ip.snapshot();
	
		Info.write("");
		/* Info.write("Example times using the 'Lena' image:");
		Info.write("");
		Info.write("Time   Machine                Viewer");
		Info.write(" 2.0   PentiumPro/200, WinNT  Explorer 3.0");
		Info.write(" 3.2   PPC604e/225, MacOS     Explorer 3.01");
		Info.write(" 3.5   Pentium/166. WinNT     Netscape 4.0 PR4");
		Info.write(" 4.4   Pentium/166, Win95     Explorer 3.0");
		Info.write("12.2   Pentium/166. Win95     Netscape 3.01");
		Info.write("28.8   Sun UltraSparc/167     Netscape 3.0");
		Info.write(""); */

		for (int i=0; i <4; i++) {
			ip.invert();
			imp.updateAndDraw();
		}
		for (int i=0; i <4; i++) {
			ip.flipVertical();
			imp.updateAndDraw();
		}
		ip.flipHorizontal(); imp.updateAndDraw();
		ip.flipHorizontal(); imp.updateAndDraw();
		for (int i=0; i <6; i++) {
			ip.smooth();
			imp.updateAndDraw();
		}
		ip.reset();
		for (int i=0; i <6; i++) {
			ip.sharpen();
			imp.updateAndDraw();
		}
		ip.reset();
		ip.smooth(); imp.updateAndDraw();
		ip.findEdges(); imp.updateAndDraw();
		ip.invert(); imp.updateAndDraw();
		ip.autoThreshold(); imp.updateAndDraw();
		ip.reset();
		ip.medianFilter(); imp.updateAndDraw();
		for (int i=0; i <360; i +=15) {
			ip.reset();
			ip.rotate(i);
			imp.updateAndDraw();
		}
		double scale = 1.5;
		for (int i=0; i <8; i++) {
			ip.reset();
			ip.scale(scale, scale, false);
			imp.updateAndDraw();
			scale = scale*1.5;
		}
		for (int i=0; i <12; i++) {
			ip.reset();
			scale = scale/1.5;
			ip.scale(scale, scale, false);
			imp.updateAndDraw();
		}
		ip.reset();
		imp.updateAndDraw();
		imp.unreserve(); 
	}

}


