/*
 *
 * Threaded Behavior Protocols  - Parsers, Transformations
 * Copyright (C) 2008   DSRG, Charles University in Prague
 *                      http://dsrg.mff.cuni.cz/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA
 *
 */
package org.ow2.dsrg.fm.tbplib.resolved.visitor;

import org.ow2.dsrg.fm.tbplib.resolved.*;
import org.ow2.dsrg.fm.tbplib.resolved.events.TBPResolvedAcceptRequest;
import org.ow2.dsrg.fm.tbplib.resolved.events.TBPResolvedEmit;
import org.ow2.dsrg.fm.tbplib.resolved.events.TBPResolvedEmitResponse;


public interface TBPResolvedVisitor<E> {
	
	E visitResolvedImperativeBinaryNode(TBPResolvedImperativeBinaryNode node);
	E visitResolvedImperativeNaryNode(TBPResolvedImperativeNaryNode node);
	E visitResolvedImperativeLeafNode(TBPResolvedImperativeLeafNode node);
	E visitResolvedImperativeUnaryNode(TBPResolvedImperativeUnaryNode node);
	
	E visitResolvedProvisionBinaryNode(TBPResolvedProvisionBinaryNode node);
	E visitResolvedProvisionNaryNode(TBPResolvedProvisionNaryNode node);
	E visitResolvedProvisionLeafNode(TBPResolvedProvisionLeafNode node);
	E visitResolvedProvisionUnaryNode(TBPResolvedProvisionUnaryNode node);
	
	E visitResolvedLimitedReentrancy(TBPResolvedLimitedReentrancy node);
	E visitResolvedAlternative(TBPResolvedAlternative resolvedAlternative);
	E visitResolvedParallel(TBPResolvedParallel resolvedParallel);
	E visitResolvedParallelOr(TBPResolvedParallelOr resolvedParallelOr);
	E visitResolvedRepetition(TBPResolvedRepetition resolvedRepetition);
	E visitResolvedProvisionNull(TBPResolvedProvisionNull resolvedProvisionNull);
	E visitResolvedProvisionContainerNode(TBPResolvedProvisionContainerNode resolvedContainer);
	E visitResolvedProvisionSequence(TBPResolvedProvisionSequence resolvedSequence);

	
	E visitResolvedAcceptRequest(TBPResolvedAcceptRequest resolvedAcceptRequest);
	E visitResolvedEmitResponse(TBPResolvedEmitResponse resolvedEmitResponse);
	
	
	// Imperative part
	
	E visitResolvedImperativeNull(
			TBPResolvedImperativeNull resolvedImperativeNull);
	E visitResolvedSync(TBPResolvedSync resolvedSync);
	E visitResolvedIf(TBPResolvedIf resolvedIf);
	E visitResolvedSwitch(TBPResolvedSwitch resolvedSwitch);
	E visitResolvedValue(TBPResolvedValue resolvedValue);
	E visitResolvedReturn(TBPResolvedReturn resolvedReturn);
	E visitResolvedAssignment(TBPResolvedAssignment resolvedAssignment);
	E visitResolvedWhile(TBPResolvedWhile resolvedWhile);
	E visitResolvedImperativeSequence(TBPResolvedImperativeSequence 
			resolvedImperativeSequence);
	
	E visitResolvedMethodDeclaration(
			TBPResolvedMethodDefinition resolvedMethodDeclaration);
	E visitResolvedMangledReaction(TBPResolvedMangledReaction node);
	E visitResolvedThreadContainerNode(TBPResolvedThreadContainerNode node);
	
	E visitResolvedEmit(TBPResolvedEmit resolvedEmit);
	E visitResolvedUndefinedEmit(TBPResolvedUndefinedEmit resolvedEmit);
}
