/*
 *
 * Threaded Behavior Protocols  - Parsers, Transformations
 * Copyright (C) 2008   DSRG, Charles University in Prague
 *                      http://dsrg.mff.cuni.cz/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA
 *
 */
package org.ow2.dsrg.fm.tbplib.resolved.events;

import org.ow2.dsrg.fm.tbplib.resolved.ConstantRef;
import org.ow2.dsrg.fm.tbplib.resolved.TBPResolvedImperativeLeafNode;
import org.ow2.dsrg.fm.tbplib.resolved.util.Binding;
import org.ow2.dsrg.fm.tbplib.resolved.visitor.TBPResolvedVisitor;

/**
 * Helper class denoting end of inlined code.
 * It has not corresponding method in {@link TBPResolvedVisitor}
 * because it is present in automatons only. 
 * 
 * @author caitt3am
 */
public class TBPResolvedTau extends TBPResolvedImperativeLeafNode {
	
	Binding b;
	ConstantRef return_value;
	
	public TBPResolvedTau(Binding binding, ConstantRef return_value){
		this.b = binding;
		this.return_value = return_value;
	}

	public final Binding getBinding() {
		return b;
	}

	public final ConstantRef getReturnValue() {
		return return_value;
	}
	
	@Override
	public String toString() {
		StringBuilder bld = new StringBuilder("TAU(").append(b.toString());
		if(return_value != null)
			bld.append(" : ").append(return_value.getName());
		bld.append(")");
		return bld.toString();
	}
}
