/*
 *
 * Threaded Behavior Protocols  - Parsers, Transformations
 * Copyright (C) 2008   DSRG, Charles University in Prague
 *                      http://dsrg.mff.cuni.cz/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA
 *
 */
package org.ow2.dsrg.fm.tbplib.parsed.visitor;

import org.ow2.dsrg.fm.tbplib.parsed.*;


public interface TBPParsedVisitor<E> {

	E visitParsedImperativeBinaryNode(TBPParsedImperativeBinaryNode node);
	
	E visitParsedImperativeNaryNode(TBPParsedImperativeNaryNode node);
	E visitParsedImperativeLeafNode(TBPParsedImperativeLeafNode node);
	E visitParsedImperativeUnaryNode(TBPParsedImperativeUnaryNode node);
	
	
	E visitParsedProvisionBinaryNode(TBPParsedProvisionBinaryNode node); 
	E visitParsedProvisionNaryNode(TBPParsedProvisionNaryNode node);
	E visitParsedProvisionLeafNode(TBPParsedProvisionLeafNode node) ;
	E visitParsedProvisionUnaryNode(TBPParsedProvisionUnaryNode parsedProvisionUnaryNode);
	
	E visitParsedImperativeSequence(TBPParsedImperativeSequence node);
	
	E visitParsedSwitch(TBPParsedSwitch node) ;
	E visitParsedIf(TBPParsedIf node) ;
	
	E visitParsedValue(TBPParsedValue node);
	E visitParsedReturn(TBPParsedReturn node);
	
	E visitParsedWhile(TBPParsedWhile node);
	
	E visitParsedAssignment(TBPParsedAssignment node);
	
	E visitParsedMethodDeclaration(TBPParsedMethodDeclaration node);
	
	E visitParsedSync(TBPParsedSync node);
	
	E visitParsedImperativeNull(TBPParsedImperativeNull node);
	E visitParsedEmit(TBPParsedEmit node);
	
	E visitParsedAlternative(TBPParsedAlternative node);
	E visitParsedParallel(TBPParsedParallel  node) ;
	E visitParsedParallelOr(TBPParsedParallelOr node);
	E visitParsedSequence(TBPParsedSequence node);
	
	E visitParsedAccept(TBPParsedAccept node) ;
	
	E visitParsedNull(TBPParsedProvisionNull node) ;
	
	E visitLimitedReentrancy(TBPLimitedReentrancy node) ;
	E visitParsedRepetition(TBPParsedRepetition node) ;
	E visitUnlimitedReentrancy(TBPUnlimitedReentrancy node) ;

	E visitParsedProvisionContainerNode(
			TBPParsedProvisionContainerNode node);

	E visitParsedThreadContainerNode(TBPParsedThreadContainerNode node);
		
}
