/*
 *
 * Threaded Behavior Protocols  - Parsers, Transformations
 * Copyright (C) 2008   DSRG, Charles University in Prague
 *                      http://dsrg.mff.cuni.cz/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA
 *
 */
package org.ow2.dsrg.fm.tbplib.parsed;

import org.ow2.dsrg.fm.tbplib.parsed.visitor.TBPParsedVisitor;

/**
 * In TBP there are two kinds of values: variable names and method calls. This class
 * represents both of them. One field is always null.
 *  
 * @author caitt3am
 *
 */
public class TBPParsedValue extends TBPParsedImperativeLeafNode {

	private String varname;
	private MethodCall mc;
	
	public TBPParsedValue(String varname) {
		this.varname = varname;
		this.mc = null;
	}
	
	public TBPParsedValue(MethodCall mc) {
		this.mc = mc;
		this.varname = null;
	}
	
	public String getVarname() {
		return varname;
	}
	
	public void setVarname(String varname) {
		if(mc != null)
			throw new RuntimeException("Value cannot be variable and method call together.");
		this.varname = varname;
	}
	
	public MethodCall getMethodCall() {
		return mc;
	}
	
	public void setMethodCall(MethodCall mc) {
		if(varname != null)
			throw new RuntimeException("Value cannot be variable and method call together.");
		this.mc = mc;
	}
	@Override
	public <E> E visit(TBPParsedVisitor<E> visitor) {
		return visitor.visitParsedValue(this);
	}
}
