/*
 *
 * Threaded Behavior Protocols  - Parsers, Transformations
 * Copyright (C) 2008   DSRG, Charles University in Prague
 *                      http://dsrg.mff.cuni.cz/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA
 *
 */
package org.ow2.dsrg.fm.tbplib.parsed;

import java.util.List;

import org.ow2.dsrg.fm.tbplib.parsed.visitor.TBPParsedVisitor;

/**
 * @author caitt3am
 *
 */
public class TBPParsedSwitch extends TBPParsedImperativeNaryNode {

	private final List<String> cases;
	private final TBPParsedImperativeNode defaultBranch;
	private final TBPParsedValue value;

	public TBPParsedSwitch(List<TBPParsedImperativeNode> branches) {

		this.cases = null;
		this.defaultBranch = null;
		this.value = null;
		for(TBPParsedImperativeNode branch : branches){
			addChild(branch);
		}
	}
	
	public TBPParsedSwitch(
			TBPParsedValue value,
			List<TBPParsedImperativeNode> branches,
			List<String> cases) {
		
				this.value = value;
				int csize = cases.size();
				int bsize = branches.size();
				assert csize == bsize || bsize==csize+1;
				
				this.cases = cases;
				if(bsize-1 == csize){
					this.defaultBranch = branches.get(csize);
				} else {
					this.defaultBranch = null;
				}
				for(TBPParsedImperativeNode branch : branches){
					assert branch != null;
					addChild(branch);
				}
	}

	public boolean isNondeterministic(){
		return cases == null;
	}

	public List<String> getCases() {
		return cases;
	}
	
	public TBPParsedValue getValue() {
		return value;
	}
	
	public TBPParsedImperativeNode getDefaultBranch() {
		return defaultBranch;
	}
	
	@Override
	public <E> E visit(TBPParsedVisitor<E> visitor) {
		return visitor.visitParsedSwitch(this);
	}
}
