/*
 *
 * Threaded Behavior Protocols  - Parsers, Transformations
 * Copyright (C) 2008   DSRG, Charles University in Prague
 *                      http://dsrg.mff.cuni.cz/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA
 *
 */
package org.ow2.dsrg.fm.tbplib.parsed;

import java.util.List;

import org.ow2.dsrg.fm.tbplib.parsed.visitor.TBPParsedVisitor;

/**
 *  
 * @author caitt3am
 *
 */
public class TBPParsedMethodDeclaration extends TBPParsedImperativeUnaryNode {

	private final String iface;
	private final String method_name;
	private final List<String> types_and_names;
	private final String ret_type;
	
	public TBPParsedMethodDeclaration(
			String iface, String method_name,
			List<String> types_and_names,
			String ret_type,
			TBPParsedImperativeNode code) {
		super(code);
		this.iface = iface;
		this.method_name = method_name;
		this.types_and_names = types_and_names;
		this.ret_type = ret_type;
	}
	
	public TBPParsedMethodDeclaration(
			List<String> nameParts,
			List<String> types_and_names,
			String ret_type,
			TBPParsedImperativeNode code) {
		super(code);
		assert nameParts.size() >= 2;
		this.iface = MethodCall.interfaceName(nameParts);
		this.method_name = nameParts.get(nameParts.size()-1);
		this.types_and_names = types_and_names;
		this.ret_type = ret_type;
	}
	

	@Override
	public <E> E visit(TBPParsedVisitor<E> visitor) {
		return visitor.visitParsedMethodDeclaration(this);
	}

	public String getInterface() {
		return iface;
	}
	
	public String getMethod() {
		return method_name;
	}
	
	public List<String> getTypesAndNames() {
		return types_and_names;
	}
	
	public String getReturnType() {
		return ret_type;
	}
	
	public String getFullname() {
		return getInterface() + "." + getMethod();
		
	}
}
