/*
 *
 * Threaded Behavior Protocols  - Parsers, Transformations
 * Copyright (C) 2008   DSRG, Charles University in Prague
 *                      http://dsrg.mff.cuni.cz/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA
 *
 */
package org.ow2.dsrg.fm.tbplib.parsed;

import org.ow2.dsrg.fm.tbplib.parsed.visitor.TBPParsedVisitor;

/**
 * @author caitt3am
 *
 */
public class TBPParsedAccept extends TBPParsedProvisionLeafNode {

	private final MethodCall mc;
	private final String return_value;
	
	public TBPParsedAccept(MethodCall mc, String return_value) {
		this.mc = mc;
		this.return_value = return_value;		
	}
	
	@Override
	public <E> E visit(TBPParsedVisitor<E> visitor) {
		return visitor.visitParsedAccept(this);
	}
	
	public MethodCall getMethodCall() {
		return mc;
	}
	
	public String getInterface(){
		return mc.getInterface();
	}
	
	public String getMethod(){
		return mc.getMethod();
	}
	
	public String getReturnValue() {
		return return_value;
	}
	
	public String getFullname(){
		return mc.getFullname();
	}
	
	public void setInterface(String ifaceName){
		mc.setInterface(ifaceName);
	}
	
	public void setMethod(String methodName){
		mc.setMethod(methodName);
	}
}
