/*
 *
 * Threaded Behavior Protocols  - Parsers, Transformations
 * Copyright (C) 2008   DSRG, Charles University in Prague
 *                      http://dsrg.mff.cuni.cz/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA
 *
 */
package org.ow2.dsrg.fm.tbplib.ltsa;

/**
 * Edge of a graph. It has two ends and carries payload - integer 
 * for provisions, general Object for imperative code.
 *  
 * @author caitt3am
 *
 */
public class Edge {
	
	private Object data;
	private int symbol;
	private State target;
	private final State from;
	
	/**
	 * Constructs edge for provision part.
	 */
	public Edge(int symbol, State to){
		this.symbol = symbol;
		this.target = to;
		this.from = null;
	}
	
	/**
	 * Constructs edge for imperative part.
	 */
	public Edge(Object data, State from, State to) {
		setData(data);
		this.target = to;
		this.from = from;
	}
	
	public State getTarget() {
		return target;
	}

	public Object getData() {
		return data;
	}

	public void setData(Object data) {
		this.data = data;
	}

	public int getSymbol() {
		return symbol;
	}

	public final State getSource() {
		return from;
	}

	public void setTarget(State target) {
		this.target = target;
	}
}
