/*
 *
 * Threaded Behavior Protocols  - Parsers, Transformations
 * Copyright (C) 2008   DSRG, Charles University in Prague
 *                      http://dsrg.mff.cuni.cz/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA
 *
 */
package org.ow2.dsrg.fm.tbplib;

import org.ow2.dsrg.fm.tbplib.resolved.ConstantRef;
import org.ow2.dsrg.fm.tbplib.resolved.TBPResolvedVardef;
import org.ow2.dsrg.fm.tbplib.resolved.util.Binding;

/**
 * EventTable keeps track of several interesting types of events 
 * and assigns them unique id number. These ids can be then used
 * to refer to this events.
 * 
 * EventTable never assigns one event more than on id.
 *  
 * This table is filled during component resolving and can be shared 
 * across components.
 * 
 * @author caitt3am
 *
 */
public interface EventTable {

	public enum EventType {
		REQUEST, RESPONSE, ASSIGNMENT
	}
	
	/**
	 * Returns event code for requesting method 
	 * @param ms - must be filled with constants
	 * @return event code
	 */
	int assignIdToRequest(Binding ms);
	/**
	 * Returns event code for response retValue of method fullname
	 * @param fullname
	 * @param retValue - can be null if fullname denotes procedure
	 * @return event code
	 */
	int assignIdToResponse(String fullname, ConstantRef retValue);
	
	/**
	 * Returns event code for assignment
	 * @param to - component variable on the left side of the assignment
	 * @param value - constant to be assigned
	 * @return event code
	 */
	int assignIdToAssignment(TBPResolvedVardef to, String value);

	EventType getType(int code);
}
