/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.Resetable;
import org.apache.derby.impl.jdbc.ConnectionChild;
import org.apache.derby.impl.jdbc.EmbedConnection;
import org.apache.derby.impl.jdbc.EmbedResultSet;
import org.apache.derby.impl.jdbc.ReaderToAscii;
import org.apache.derby.impl.jdbc.UTF8Reader;
import org.apache.derby.impl.jdbc.Util;

final class EmbedClob
extends ConnectionChild
implements Clob {
    private boolean isString;
    private InputStream myStream;
    private String myString;

    protected EmbedClob(DataValueDescriptor dataValueDescriptor, EmbedConnection embedConnection) throws StandardException {
        block4: {
            super(embedConnection);
            this.myStream = dataValueDescriptor.getStream();
            if (this.myStream == null) {
                this.isString = true;
                this.myString = dataValueDescriptor.getString();
            } else {
                try {
                    ((Resetable)((Object)this.myStream)).initStream();
                }
                catch (StandardException standardException) {
                    if (!standardException.getMessageId().equals("40XD0")) break block4;
                    throw StandardException.newException("XJ073.S");
                }
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public long length() throws SQLException {
        Object object;
        if (this.isString) {
            return this.myString.length();
        }
        Object object2 = object = this.getConnectionSynchronization();
        synchronized (object2) {
            long l;
            Reader reader;
            block13: {
                reader = null;
                this.setupContextStack();
                reader = this.getCharacterStream();
                long l2 = 0L;
                while ((l = reader.skip(32768L)) != -1L) {
                    l2 += l;
                }
                reader.close();
                reader = null;
                l = l2;
                Object var9_7 = null;
                if (reader == null) break block13;
                try {
                    reader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.restoreContextStack();
            {
                return l;
                catch (Throwable throwable) {
                    throw EmbedClob.noStateChangeLOB(throwable);
                }
            }
            catch (Throwable throwable) {
                Object var9_8 = null;
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                this.restoreContextStack();
                throw throwable;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getSubString(long l, int n) throws SQLException {
        Object object;
        if (l < 1L) {
            throw Util.generateCsSQLException("XJ070.S", new Long(l));
        }
        if (n <= 0) {
            throw Util.generateCsSQLException("XJ071.S", new Integer(n));
        }
        if (this.isString) {
            int n2;
            int n3 = this.myString.length();
            if ((long)n3 < l) {
                throw Util.generateCsSQLException("XJ076.S", new Long(l));
            }
            int n4 = (int)l + n - 1;
            int n5 = (int)l - 1;
            if (n3 > n4) {
                n2 = n4;
                return this.myString.substring(n5, n2);
            }
            n2 = n3;
            return this.myString.substring(n5, n2);
        }
        Object object2 = object = this.getConnectionSynchronization();
        synchronized (object2) {
            String string;
            this.setupContextStack();
            UTF8Reader uTF8Reader = null;
            try {
                try {
                    int n6;
                    uTF8Reader = this.getCharacterStreamAtPos(l, object);
                    if (uTF8Reader == null) {
                        throw StandardException.newException("XJ076.S", new Long(l));
                    }
                    StringBuffer stringBuffer = new StringBuffer(n);
                    for (int i = n; i > 0 && (n6 = uTF8Reader.readInto(stringBuffer, i)) != -1; i -= n6) {
                    }
                    uTF8Reader.close();
                    uTF8Reader = null;
                    string = stringBuffer.toString();
                    Object var11_13 = null;
                    if (uTF8Reader != null) {
                        uTF8Reader.close();
                    }
                }
                catch (Throwable throwable) {
                    throw EmbedClob.noStateChangeLOB(throwable);
                }
            }
            catch (Throwable throwable) {
                Object var11_14 = null;
                if (uTF8Reader != null) {
                    uTF8Reader.close();
                }
                this.restoreContextStack();
                throw throwable;
            }
            this.restoreContextStack();
            return string;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Reader getCharacterStream() throws SQLException {
        Object object;
        if (this.isString) {
            return new StringReader(this.myString);
        }
        Object object2 = object = this.getConnectionSynchronization();
        synchronized (object2) {
            this.setupContextStack();
            try {
                UTF8Reader uTF8Reader = this.getCharacterStreamAtPos(1L, object);
                return uTF8Reader;
            }
            catch (Throwable throwable) {
                throw EmbedClob.noStateChangeLOB(throwable);
            }
            finally {
                this.restoreContextStack();
            }
        }
    }

    public InputStream getAsciiStream() throws SQLException {
        return new ReaderToAscii(this.getCharacterStream());
    }

    private UTF8Reader getCharacterStreamAtPos(long l, Object object) throws IOException, StandardException {
        long l2;
        ((Resetable)((Object)this.myStream)).resetStream();
        UTF8Reader uTF8Reader = new UTF8Reader(this.myStream, 0L, this, object);
        for (long i = l - 1L; i > 0L; i -= l2) {
            l2 = uTF8Reader.skip(i);
            if (l2 != -1L) continue;
            return null;
        }
        return uTF8Reader;
    }

    /*
     * Exception decompiling
     */
    public long position(String var1_1, long var2_2) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK], 4[TRYBLOCK]], but top level block is 15[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public long position(Clob var1_1, long var2_2) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK], 1[TRYBLOCK]], but top level block is 20[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void finalize() {
        if (!this.isString) {
            ((Resetable)((Object)this.myStream)).closeStream();
        }
    }

    public int setString(long l, String string) throws SQLException {
        throw Util.notImplemented();
    }

    public int setString(long l, String string, int n, int n2) throws SQLException {
        throw Util.notImplemented();
    }

    public OutputStream setAsciiStream(long l) throws SQLException {
        throw Util.notImplemented();
    }

    public Writer setCharacterStream(long l) throws SQLException {
        throw Util.notImplemented();
    }

    public void truncate(long l) throws SQLException {
        throw Util.notImplemented();
    }

    static SQLException noStateChangeLOB(Throwable throwable) {
        if (throwable instanceof StandardException && ((StandardException)throwable).getMessageId().equals("40XD0")) {
            throwable = StandardException.newException("XJ073.S");
        }
        return EmbedResultSet.noStateChangeException(throwable);
    }
}

