/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.stomp;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.jms.Destination;
import javax.jms.JMSException;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.transport.stomp.ProtocolException;
import org.apache.activemq.transport.stomp.Stomp;
import org.apache.activemq.transport.stomp.StompFrame;

public interface FrameTranslator {
    public ActiveMQMessage convertFrame(StompFrame var1) throws JMSException, ProtocolException;

    public StompFrame convertMessage(ActiveMQMessage var1) throws IOException, JMSException;

    public String convertDestination(Destination var1);

    public ActiveMQDestination convertDestination(String var1) throws ProtocolException;

    public static final class Helper {
        public static void copyStandardHeadersFromMessageToFrame(ActiveMQMessage message, StompFrame command, FrameTranslator ft) throws IOException {
            Map properties;
            Map headers = command.getHeaders();
            headers.put("destination", ft.convertDestination(message.getDestination()));
            headers.put("message-id", message.getJMSMessageID());
            if (message.getJMSCorrelationID() != null) {
                headers.put("correlation-id", message.getJMSCorrelationID());
            }
            headers.put("expires", "" + message.getJMSExpiration());
            if (message.getJMSRedelivered()) {
                headers.put("redelivered", "true");
            }
            headers.put("priority", "" + message.getJMSPriority());
            if (message.getJMSReplyTo() != null) {
                headers.put("reply-to", ft.convertDestination(message.getJMSReplyTo()));
            }
            headers.put("timestamp", "" + message.getJMSTimestamp());
            if (message.getJMSType() != null) {
                headers.put("type", message.getJMSType());
            }
            if ((properties = message.getProperties()) != null) {
                headers.putAll(properties);
            }
        }

        public static void copyStandardHeadersFromFrameToMessage(StompFrame command, ActiveMQMessage msg, FrameTranslator ft) throws ProtocolException, JMSException {
            HashMap headers = new HashMap(command.getHeaders());
            String destination = (String)headers.remove("destination");
            msg.setDestination(ft.convertDestination(destination));
            msg.setJMSCorrelationID((String)headers.remove("correlation-id"));
            Object o = headers.remove("expires");
            if (o != null) {
                msg.setJMSExpiration(Long.parseLong((String)o));
            }
            if ((o = headers.remove("priority")) != null) {
                msg.setJMSPriority(Integer.parseInt((String)o));
            }
            if ((o = headers.remove("type")) != null) {
                msg.setJMSType((String)o);
            }
            if ((o = headers.remove("reply-to")) != null) {
                msg.setJMSReplyTo(ft.convertDestination((String)o));
            }
            if ((o = headers.remove(Stomp.Headers.Send.PERSISTENT)) != null) {
                msg.setPersistent("true".equals(o));
            }
            msg.setProperties(headers);
        }
    }
}

