/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transaction;

import java.io.IOException;
import javax.transaction.xa.XAException;
import org.apache.activemq.broker.TransactionBroker;
import org.apache.activemq.command.TransactionId;
import org.apache.activemq.command.XATransactionId;
import org.apache.activemq.store.TransactionStore;
import org.apache.activemq.transaction.Transaction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class XATransaction
extends Transaction {
    private static final Log log = LogFactory.getLog(XATransaction.class);
    private final TransactionStore transactionStore;
    private final XATransactionId xid;
    private final TransactionBroker broker;

    public XATransaction(TransactionStore transactionStore, XATransactionId xid, TransactionBroker broker) {
        this.transactionStore = transactionStore;
        this.xid = xid;
        this.broker = broker;
    }

    public void commit(boolean onePhase) throws XAException, IOException {
        if (log.isDebugEnabled()) {
            log.debug("XA Transaction commit: " + this.xid);
        }
        switch (this.getState()) {
            case 0: {
                this.checkForPreparedState(onePhase);
                this.setStateFinished();
                break;
            }
            case 1: {
                this.checkForPreparedState(onePhase);
                this.doPrePrepare();
                this.setStateFinished();
                this.transactionStore.commit(this.getTransactionId(), false);
                this.doPostCommit();
                break;
            }
            case 2: {
                this.setStateFinished();
                this.transactionStore.commit(this.getTransactionId(), true);
                this.doPostCommit();
                break;
            }
            default: {
                this.illegalStateTransition("commit");
            }
        }
    }

    private void illegalStateTransition(String callName) throws XAException {
        XAException xae = new XAException("Cannot call " + callName + " now.");
        xae.errorCode = -6;
        throw xae;
    }

    private void checkForPreparedState(boolean onePhase) throws XAException {
        if (!onePhase) {
            XAException xae = new XAException("Cannot do 2 phase commit if the transaction has not been prepared.");
            xae.errorCode = -6;
            throw xae;
        }
    }

    private void doPrePrepare() throws XAException, IOException {
        try {
            this.prePrepare();
        }
        catch (XAException e) {
            throw e;
        }
        catch (Throwable e) {
            log.warn("PRE-PREPARE FAILED: ", e);
            this.rollback();
            XAException xae = new XAException("PRE-PREPARE FAILED: Transaction rolled back.");
            xae.errorCode = 104;
            xae.initCause(e);
            throw xae;
        }
    }

    private void doPostCommit() throws XAException {
        try {
            this.fireAfterCommit();
        }
        catch (Throwable e) {
            log.warn("POST COMMIT FAILED: ", e);
            XAException xae = new XAException("POST COMMIT FAILED");
            xae.errorCode = -3;
            xae.initCause(e);
            throw xae;
        }
    }

    public void rollback() throws XAException, IOException {
        if (log.isDebugEnabled()) {
            log.debug("XA Transaction rollback: " + this.xid);
        }
        switch (this.getState()) {
            case 0: {
                this.setStateFinished();
                break;
            }
            case 1: {
                this.setStateFinished();
                this.transactionStore.rollback(this.getTransactionId());
                this.doPostRollback();
                break;
            }
            case 2: {
                this.setStateFinished();
                this.transactionStore.rollback(this.getTransactionId());
                this.doPostRollback();
            }
        }
    }

    private void doPostRollback() throws XAException {
        try {
            this.fireAfterRollback();
        }
        catch (Throwable e) {
            log.warn("POST ROLLBACK FAILED: ", e);
            XAException xae = new XAException("POST ROLLBACK FAILED");
            xae.errorCode = -3;
            xae.initCause(e);
            throw xae;
        }
    }

    public int prepare() throws XAException, IOException {
        if (log.isDebugEnabled()) {
            log.debug("XA Transaction prepare: " + this.xid);
        }
        switch (this.getState()) {
            case 0: {
                this.setStateFinished();
                return 3;
            }
            case 1: {
                this.doPrePrepare();
                this.setState((byte)2);
                this.transactionStore.prepare(this.getTransactionId());
                return 0;
            }
        }
        this.illegalStateTransition("prepare");
        return 3;
    }

    private void setStateFinished() {
        this.setState((byte)3);
        this.broker.removeTransaction(this.xid);
    }

    public TransactionId getTransactionId() {
        return this.xid;
    }
}

