/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.rapid;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicInteger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.activeio.journal.RecordLocation;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.command.JournalTopicAck;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.command.SubscriptionInfo;
import org.apache.activemq.kaha.ListContainer;
import org.apache.activemq.kaha.MapContainer;
import org.apache.activemq.kaha.Store;
import org.apache.activemq.kaha.StringMarshaller;
import org.apache.activemq.store.MessageRecoveryListener;
import org.apache.activemq.store.TopicMessageStore;
import org.apache.activemq.store.rapid.RapidMessageStore;
import org.apache.activemq.store.rapid.RapidPersistenceAdapter;
import org.apache.activemq.transaction.Synchronization;
import org.apache.activemq.util.SubscriptionKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RapidTopicMessageStore
extends RapidMessageStore
implements TopicMessageStore {
    private static final Log log = LogFactory.getLog(RapidTopicMessageStore.class);
    private HashMap ackedLastAckLocations = new HashMap();
    private final MapContainer subscriberContainer;
    private final MapContainer ackContainer;
    private final Store store;
    private Map subscriberAcks = new ConcurrentHashMap();
    static /* synthetic */ Class class$java$lang$String;

    public RapidTopicMessageStore(RapidPersistenceAdapter adapter, ActiveMQTopic destination, MapContainer messageContainer, MapContainer subsContainer, MapContainer ackContainer) throws IOException {
        super(adapter, destination, messageContainer);
        this.subscriberContainer = subsContainer;
        this.ackContainer = ackContainer;
        this.store = adapter.getStore();
        Iterator i = this.subscriberContainer.keySet().iterator();
        while (i.hasNext()) {
            Object key = i.next();
            this.addSubscriberAckContainer(key);
        }
    }

    public void recoverSubscription(String clientId, String subscriptionName, MessageRecoveryListener listener) throws Exception {
        String key = this.getSubscriptionKey(clientId, subscriptionName);
        ListContainer list = (ListContainer)this.subscriberAcks.get(key);
        if (list != null) {
            Iterator i = list.iterator();
            while (i.hasNext()) {
                Object msg = this.messageContainer.get(i.next());
                if (msg != null) {
                    if (msg.getClass() == (class$java$lang$String == null ? RapidTopicMessageStore.class$("java.lang.String") : class$java$lang$String)) {
                        listener.recoverMessageReference((String)msg);
                    } else {
                        listener.recoverMessage((Message)msg);
                    }
                }
                listener.finished();
            }
        } else {
            listener.finished();
        }
    }

    public void recoverNextMessages(String clientId, String subscriptionName, MessageId lastMessageId, int maxReturned, MessageRecoveryListener listener) throws Exception {
        String key = this.getSubscriptionKey(clientId, subscriptionName);
        ListContainer list = (ListContainer)this.subscriberAcks.get(key);
        if (list != null) {
            boolean startFound = false;
            int count = 0;
            Iterator i = list.iterator();
            while (i.hasNext() && count < maxReturned) {
                Object msg = this.messageContainer.get(i.next());
                if (msg != null) {
                    if (msg.getClass() == (class$java$lang$String == null ? RapidTopicMessageStore.class$("java.lang.String") : class$java$lang$String)) {
                        String ref = msg.toString();
                        if (startFound || lastMessageId == null) {
                            listener.recoverMessageReference(ref);
                            ++count;
                        } else if (!startFound || ref.equals(lastMessageId.toString())) {
                            startFound = true;
                        }
                    } else {
                        Message message = (Message)msg;
                        if (startFound || lastMessageId == null) {
                            listener.recoverMessage(message);
                            ++count;
                        } else if (!startFound && message.getMessageId().equals(lastMessageId)) {
                            startFound = true;
                        }
                    }
                }
                listener.finished();
            }
        } else {
            listener.finished();
        }
    }

    public SubscriptionInfo lookupSubscription(String clientId, String subscriptionName) throws IOException {
        return (SubscriptionInfo)this.subscriberContainer.get(this.getSubscriptionKey(clientId, subscriptionName));
    }

    public void addSubsciption(String clientId, String subscriptionName, String selector, boolean retroactive) throws IOException {
        SubscriptionInfo info = new SubscriptionInfo();
        info.setDestination(this.destination);
        info.setClientId(clientId);
        info.setSelector(selector);
        info.setSubcriptionName(subscriptionName);
        String key = this.getSubscriptionKey(clientId, subscriptionName);
        if (!this.subscriberContainer.containsKey(key)) {
            this.subscriberContainer.put(key, info);
        }
        this.addSubscriberAckContainer(key);
    }

    public synchronized void addMessage(ConnectionContext context, Message message) throws IOException {
        int subscriberCount = this.subscriberAcks.size();
        if (subscriberCount > 0) {
            String id = message.getMessageId().toString();
            this.ackContainer.put(id, new AtomicInteger(subscriberCount));
            Iterator i = this.subscriberAcks.keySet().iterator();
            while (i.hasNext()) {
                Object key = i.next();
                ListContainer container = this.store.getListContainer(key, "durable-subs");
                container.add(id);
            }
            super.addMessage(context, message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acknowledge(ConnectionContext context, String clientId, String subscriptionName, final MessageId messageId) throws IOException {
        final boolean debug = log.isDebugEnabled();
        JournalTopicAck ack = new JournalTopicAck();
        ack.setDestination(this.destination);
        ack.setMessageId(messageId);
        ack.setMessageSequenceId(messageId.getBrokerSequenceId());
        ack.setSubscritionName(subscriptionName);
        ack.setClientId(clientId);
        ack.setTransactionId(context.getTransaction() != null ? context.getTransaction().getTransactionId() : null);
        final RecordLocation location = this.peristenceAdapter.writeCommand(ack, false);
        final SubscriptionKey key = new SubscriptionKey(clientId, subscriptionName);
        if (!context.isInTransaction()) {
            if (debug) {
                log.debug("Journalled acknowledge for: " + messageId + ", at: " + location);
            }
            this.acknowledge(messageId, location, key);
        } else {
            if (debug) {
                log.debug("Journalled transacted acknowledge for: " + messageId + ", at: " + location);
            }
            RapidTopicMessageStore rapidTopicMessageStore = this;
            synchronized (rapidTopicMessageStore) {
                this.inFlightTxLocations.add(location);
            }
            this.transactionStore.acknowledge(this, ack, location);
            context.getTransaction().addSynchronization(new Synchronization(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void afterCommit() throws Exception {
                    if (debug) {
                        log.debug("Transacted acknowledge commit for: " + messageId + ", at: " + location);
                    }
                    RapidTopicMessageStore rapidTopicMessageStore = RapidTopicMessageStore.this;
                    synchronized (rapidTopicMessageStore) {
                        RapidTopicMessageStore.this.inFlightTxLocations.remove(location);
                        RapidTopicMessageStore.this.acknowledge(messageId, location, key);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void afterRollback() throws Exception {
                    if (debug) {
                        log.debug("Transacted acknowledge rollback for: " + messageId + ", at: " + location);
                    }
                    RapidTopicMessageStore rapidTopicMessageStore = RapidTopicMessageStore.this;
                    synchronized (rapidTopicMessageStore) {
                        RapidTopicMessageStore.this.inFlightTxLocations.remove(location);
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replayAcknowledge(ConnectionContext context, String clientId, String subscritionName, MessageId messageId) {
        try {
            RapidTopicMessageStore rapidTopicMessageStore = this;
            synchronized (rapidTopicMessageStore) {
                String subcriberId = this.getSubscriptionKey(clientId, subscritionName);
                String id = messageId.toString();
                ListContainer container = (ListContainer)this.subscriberAcks.get(subcriberId);
                if (container != null) {
                    container.removeFirst();
                    AtomicInteger count = (AtomicInteger)this.ackContainer.remove(id);
                    if (count != null) {
                        if (count.decrementAndGet() > 0) {
                            this.ackContainer.put(id, count);
                        } else {
                            this.messageContainer.remove(messageId.toString());
                        }
                    }
                }
            }
        }
        catch (Throwable e) {
            log.debug("Could not replay acknowledge for message '" + messageId + "'.  Message may have already been acknowledged. reason: " + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void acknowledge(MessageId messageId, RecordLocation location, SubscriptionKey key) {
        RapidTopicMessageStore rapidTopicMessageStore = this;
        synchronized (rapidTopicMessageStore) {
            this.lastLocation = location;
            this.ackedLastAckLocations.put(key, messageId);
            String subcriberId = this.getSubscriptionKey(key.getClientId(), key.getSubscriptionName());
            String id = messageId.toString();
            ListContainer container = (ListContainer)this.subscriberAcks.get(subcriberId);
            if (container != null) {
                container.removeFirst();
                AtomicInteger count = (AtomicInteger)this.ackContainer.remove(id);
                if (count != null) {
                    if (count.decrementAndGet() > 0) {
                        this.ackContainer.put(id, count);
                    } else {
                        this.messageContainer.remove(messageId.toString());
                    }
                }
            }
        }
    }

    protected String getSubscriptionKey(String clientId, String subscriberName) {
        String result = clientId + ":";
        result = result + (subscriberName != null ? subscriberName : "NOT_SET");
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecordLocation checkpoint() throws IOException {
        ArrayList cpAckedLastAckLocations;
        RapidTopicMessageStore rapidTopicMessageStore = this;
        synchronized (rapidTopicMessageStore) {
            cpAckedLastAckLocations = new ArrayList(this.ackedLastAckLocations.values());
            this.ackedLastAckLocations = new HashMap();
        }
        RecordLocation rc = super.checkpoint();
        if (!cpAckedLastAckLocations.isEmpty()) {
            Collections.sort(cpAckedLastAckLocations);
            RecordLocation t = (RecordLocation)cpAckedLastAckLocations.get(0);
            if (rc == null || t.compareTo(rc) < 0) {
                rc = t;
            }
        }
        return rc;
    }

    public void deleteSubscription(String clientId, String subscriptionName) throws IOException {
        String key = this.getSubscriptionKey(clientId, subscriptionName);
        this.subscriberContainer.remove(key);
        ListContainer list = (ListContainer)this.subscriberAcks.get(key);
        Iterator i = list.iterator();
        while (i.hasNext()) {
            String id = i.next().toString();
            AtomicInteger count = (AtomicInteger)this.ackContainer.remove(id);
            if (count == null) continue;
            if (count.decrementAndGet() > 0) {
                this.ackContainer.put(id, count);
                continue;
            }
            this.messageContainer.remove(id);
        }
    }

    public SubscriptionInfo[] getAllSubscriptions() throws IOException {
        return this.subscriberContainer.values().toArray(new SubscriptionInfo[this.subscriberContainer.size()]);
    }

    protected void addSubscriberAckContainer(Object key) throws IOException {
        ListContainer container = this.store.getListContainer(key, "durable-subs");
        StringMarshaller marshaller = new StringMarshaller();
        container.setMarshaller(marshaller);
        this.subscriberAcks.put(key, container);
    }

    public MessageId getNextMessageIdToDeliver(String clientId, String subscriptionName, MessageId messageId) throws IOException {
        MessageId result = null;
        boolean getNext = false;
        String key = this.getSubscriptionKey(clientId, subscriptionName);
        ListContainer list = (ListContainer)this.subscriberAcks.get(key);
        Iterator iter = list.iterator();
        Iterator i = list.iterator();
        while (i.hasNext()) {
            String id = i.next().toString();
            if (id.equals(messageId.toString())) {
                getNext = true;
                continue;
            }
            if (!getNext) continue;
            result = new MessageId(id);
            break;
        }
        return result;
    }

    public MessageId getPreviousMessageIdToDeliver(String clientId, String subscriptionName, MessageId messageId) throws IOException {
        MessageId result = null;
        String previousId = null;
        String key = this.getSubscriptionKey(clientId, subscriptionName);
        ListContainer list = (ListContainer)this.subscriberAcks.get(key);
        Iterator iter = list.iterator();
        Iterator i = list.iterator();
        while (i.hasNext()) {
            String id = i.next().toString();
            if (id.equals(messageId.toString())) {
                if (previousId == null) break;
                result = new MessageId(previousId);
                break;
            }
            previousId = id;
        }
        return result;
    }

    public int getMessageCount(String clientId, String subscriberName) throws IOException {
        String key = this.getSubscriptionKey(clientId, subscriberName);
        ListContainer list = (ListContainer)this.subscriberAcks.get(key);
        return list.size();
    }

    public void resetBatching(String clientId, String subscriptionName, MessageId nextId) {
    }
}

