/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.kaha.impl.index;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.util.LinkedList;
import org.apache.activemq.kaha.impl.data.DataManager;
import org.apache.activemq.kaha.impl.index.IndexItem;
import org.apache.activemq.kaha.impl.index.RedoStoreIndexItem;
import org.apache.activemq.kaha.impl.index.StoreIndexReader;
import org.apache.activemq.kaha.impl.index.StoreIndexWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class IndexManager {
    public static final String NAME_PREFIX = "index-";
    private static final Log log = LogFactory.getLog(IndexManager.class);
    private final String name;
    private File directory;
    private File file;
    private RandomAccessFile indexFile;
    private StoreIndexReader reader;
    private StoreIndexWriter writer;
    private LinkedList freeList = new LinkedList();
    private DataManager redoLog;
    private String mode;
    private long length = 0L;

    public IndexManager(File directory, String name, String mode, DataManager redoLog) throws IOException {
        this.directory = directory;
        this.name = name;
        this.mode = mode;
        this.redoLog = redoLog;
        this.initialize();
    }

    public synchronized boolean isEmpty() {
        return this.freeList.isEmpty() && this.length == 0L;
    }

    public synchronized IndexItem getIndex(long offset) throws IOException {
        return this.reader.readItem(offset);
    }

    public synchronized IndexItem refreshIndex(IndexItem item) throws IOException {
        this.reader.updateIndexes(item);
        return item;
    }

    public synchronized void freeIndex(IndexItem item) throws IOException {
        item.setActive(false);
        this.writer.updateIndexes(item);
        this.freeList.add(item);
    }

    public synchronized void storeIndex(IndexItem index) throws IOException {
        this.writer.storeItem(index);
    }

    public synchronized void updateIndexes(IndexItem index) throws IOException {
        this.writer.updateIndexes(index);
    }

    public synchronized void redo(RedoStoreIndexItem redo) throws IOException {
        this.writer.redoStoreItem(redo);
    }

    public synchronized IndexItem createNewIndex() {
        IndexItem result = this.getNextFreeIndex();
        if (result == null) {
            result = new IndexItem();
            result.setOffset(this.length);
            this.length += 51L;
        }
        return result;
    }

    public synchronized void close() throws IOException {
        if (this.indexFile != null) {
            this.indexFile.close();
            this.indexFile = null;
        }
    }

    public synchronized void force() throws IOException {
        if (this.indexFile != null) {
            this.indexFile.getFD().sync();
        }
    }

    public synchronized boolean delete() throws IOException {
        this.freeList.clear();
        if (this.indexFile != null) {
            this.indexFile.close();
            this.indexFile = null;
        }
        return this.file.delete();
    }

    private synchronized IndexItem getNextFreeIndex() {
        IndexItem result = null;
        if (!this.freeList.isEmpty()) {
            result = (IndexItem)this.freeList.removeLast();
            result.reset();
        }
        return result;
    }

    long getLength() {
        return this.length;
    }

    public synchronized void setLength(long value) {
        this.length = value;
    }

    public synchronized FileLock getLock() throws IOException {
        return this.indexFile.getChannel().tryLock();
    }

    public String toString() {
        return "IndexManager:(index-" + this.name + ")";
    }

    protected void initialize() throws IOException {
        this.file = new File(this.directory, NAME_PREFIX + this.name);
        this.indexFile = new RandomAccessFile(this.file, this.mode);
        this.reader = new StoreIndexReader(this.indexFile);
        this.writer = new StoreIndexWriter(this.indexFile, this.name, this.redoLog);
        long offset = 0L;
        while (offset + 51L <= this.indexFile.length()) {
            IndexItem index = this.reader.readItem(offset);
            if (!index.isActive()) {
                index.reset();
                this.freeList.add(index);
            }
            offset += 51L;
        }
        this.length = offset;
    }
}

