/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.filter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DestinationMapNode {
    private DestinationMapNode parent;
    private List values = new ArrayList();
    private Map childNodes = new HashMap();
    private String path = "*";
    private DestinationMapNode anyChild;
    protected static final String ANY_CHILD = "*";
    protected static final String ANY_DESCENDENT = ">";

    public DestinationMapNode(DestinationMapNode parent) {
        this.parent = parent;
    }

    public DestinationMapNode getChild(String path) {
        return (DestinationMapNode)this.childNodes.get(path);
    }

    public Collection getChildren() {
        return this.childNodes.values();
    }

    public int getChildCount() {
        return this.childNodes.size();
    }

    public DestinationMapNode getChildOrCreate(String path) {
        DestinationMapNode answer = (DestinationMapNode)this.childNodes.get(path);
        if (answer == null) {
            answer = this.createChildNode();
            answer.path = path;
            this.childNodes.put(path, answer);
        }
        return answer;
    }

    public DestinationMapNode getAnyChildNode() {
        if (this.anyChild == null) {
            this.anyChild = this.createChildNode();
        }
        return this.anyChild;
    }

    public List getValues() {
        return this.values;
    }

    public List removeValues() {
        ArrayList v = new ArrayList(this.values);
        this.parent.getAnyChildNode().getValues().removeAll(v);
        this.values.clear();
        this.pruneIfEmpty();
        return v;
    }

    public Set removeDesendentValues() {
        HashSet answer = new HashSet();
        this.removeDesendentValues(answer);
        return answer;
    }

    protected void removeDesendentValues(Set answer) {
        if (this.anyChild != null) {
            this.anyChild.removeDesendentValues(answer);
        }
        answer.addAll(this.removeValues());
    }

    public Set getDesendentValues() {
        HashSet answer = new HashSet();
        this.appendDescendantValues(answer);
        return answer;
    }

    public void add(String[] paths, int idx, Object value) {
        if (idx >= paths.length) {
            this.values.add(value);
        } else {
            if (idx == paths.length - 1) {
                this.getAnyChildNode().getValues().add(value);
            } else {
                this.getAnyChildNode().add(paths, idx + 1, value);
            }
            this.getChildOrCreate(paths[idx]).add(paths, idx + 1, value);
        }
    }

    public void remove(String[] paths, int idx, Object value) {
        if (idx >= paths.length) {
            this.values.remove(value);
            this.pruneIfEmpty();
        } else {
            if (idx == paths.length - 1) {
                this.getAnyChildNode().getValues().remove(value);
            } else {
                this.getAnyChildNode().remove(paths, idx + 1, value);
            }
            this.getChildOrCreate(paths[idx]).remove(paths, ++idx, value);
        }
    }

    public void removeAll(Set answer, String[] paths, int startIndex) {
        DestinationMapNode node = this;
        int size = paths.length;
        for (int i = startIndex; i < size && node != null; ++i) {
            String path = paths[i];
            if (path.equals(ANY_DESCENDENT)) {
                answer.addAll(node.removeDesendentValues());
                break;
            }
            node.appendMatchingWildcards(answer, paths, i);
            node = path.equals(ANY_CHILD) ? node.getAnyChildNode() : node.getChild(path);
        }
        if (node != null) {
            answer.addAll(node.removeValues());
        }
    }

    protected void appendDescendantValues(Set answer) {
        answer.addAll(this.values);
        if (this.anyChild != null) {
            this.anyChild.appendDescendantValues(answer);
        }
    }

    protected DestinationMapNode createChildNode() {
        return new DestinationMapNode(this);
    }

    public void appendMatchingWildcards(Set answer, String[] paths, int idx) {
        DestinationMapNode wildCardNode = this.getChild(ANY_CHILD);
        if (wildCardNode != null) {
            wildCardNode.appendMatchingValues(answer, paths, idx + 1);
        }
        if ((wildCardNode = this.getChild(ANY_DESCENDENT)) != null) {
            answer.addAll(wildCardNode.getDesendentValues());
        }
    }

    public void appendMatchingValues(Set answer, String[] paths, int startIndex) {
        DestinationMapNode node = this;
        boolean couldMatchAny = true;
        int size = paths.length;
        for (int i = startIndex; i < size && node != null; ++i) {
            String path = paths[i];
            if (path.equals(ANY_DESCENDENT)) {
                answer.addAll(node.getDesendentValues());
                couldMatchAny = false;
                break;
            }
            node.appendMatchingWildcards(answer, paths, i);
            node = path.equals(ANY_CHILD) ? node.getAnyChildNode() : node.getChild(path);
        }
        if (node != null) {
            DestinationMapNode child;
            answer.addAll(node.getValues());
            if (couldMatchAny && (child = node.getChild(ANY_DESCENDENT)) != null) {
                answer.addAll(child.getValues());
            }
        }
    }

    public String getPath() {
        return this.path;
    }

    protected void pruneIfEmpty() {
        if (this.parent != null && this.childNodes.isEmpty() && this.values.isEmpty()) {
            this.parent.removeChild(this);
        }
    }

    protected void removeChild(DestinationMapNode node) {
        this.childNodes.remove(node.getPath());
        this.pruneIfEmpty();
    }
}

