/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.console.command;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.List;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.activemq.console.command.AbstractCommand;
import org.apache.activemq.console.formatter.GlobalWriter;

public abstract class AbstractJmxCommand
extends AbstractCommand {
    public static final String DEFAULT_JMX_URL = "service:jmx:rmi:///jndi/rmi://localhost:1099/jmxrmi";
    private JMXServiceURL jmxServiceUrl;
    private JMXConnector jmxConnector;

    protected JMXServiceURL getJmxServiceUrl() {
        return this.jmxServiceUrl;
    }

    protected JMXServiceURL useJmxServiceUrl() throws MalformedURLException {
        if (this.getJmxServiceUrl() == null) {
            this.setJmxServiceUrl(DEFAULT_JMX_URL);
        }
        return this.getJmxServiceUrl();
    }

    protected void setJmxServiceUrl(JMXServiceURL jmxServiceUrl) {
        this.jmxServiceUrl = jmxServiceUrl;
    }

    protected void setJmxServiceUrl(String jmxServiceUrl) throws MalformedURLException {
        this.setJmxServiceUrl(new JMXServiceURL(jmxServiceUrl));
    }

    protected JMXConnector createJmxConnector() throws IOException {
        if (this.jmxConnector != null) {
            this.jmxConnector.connect();
            return this.jmxConnector;
        }
        this.jmxConnector = JMXConnectorFactory.connect(this.useJmxServiceUrl());
        return this.jmxConnector;
    }

    protected void closeJmxConnector() {
        try {
            if (this.jmxConnector != null) {
                this.jmxConnector.close();
                this.jmxConnector = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void handleOption(String token, List tokens) throws Exception {
        if (token.equals("--jmxurl")) {
            if (tokens.isEmpty() || ((String)tokens.get(0)).startsWith("-")) {
                GlobalWriter.printException(new IllegalArgumentException("JMX URL not specified."));
            }
            if (this.getJmxServiceUrl() != null) {
                GlobalWriter.printException(new IllegalArgumentException("Multiple JMX URL cannot be specified."));
                tokens.clear();
            }
            String strJmxUrl = (String)tokens.remove(0);
            try {
                this.setJmxServiceUrl(new JMXServiceURL(strJmxUrl));
            }
            catch (MalformedURLException e) {
                GlobalWriter.printException(e);
                tokens.clear();
            }
        } else {
            super.handleOption(token, tokens);
        }
    }
}

