/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.tool.wrappers.io;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import org.neodatis.odb.ODBRuntimeException;
import org.neodatis.odb.core.NeoDatisError;
import org.neodatis.odb.core.layers.layer3.IO;

public class OdbFileIO
implements IO {
    private String fileName;
    private RandomAccessFile fileAccess;
    private FileLock fileLock;

    public OdbFileIO(String wholeFileName, boolean canWrite, String password) throws IOException {
        this.init(wholeFileName, canWrite, password);
    }

    public long length() throws IOException {
        return this.fileAccess.length();
    }

    public void seek(long position) throws IOException {
        try {
            if (position < 0L) {
                throw new ODBRuntimeException(NeoDatisError.NEGATIVE_POSITION.addParameter(position));
            }
            this.fileAccess.seek(position);
        }
        catch (IOException e) {
            throw new ODBRuntimeException(NeoDatisError.GO_TO_POSITION.addParameter(position).addParameter(this.fileAccess.length()), (Throwable)e);
        }
    }

    public void write(byte b) throws IOException {
        this.fileAccess.writeByte(b);
    }

    public void write(byte[] bs, int offset, int size) throws IOException {
        this.fileAccess.write(bs, offset, size);
    }

    public int read() throws IOException {
        return this.fileAccess.read();
    }

    public long read(byte[] array, int offset, int size) throws IOException {
        return this.fileAccess.read(array, offset, size);
    }

    public void close() throws IOException {
        this.fileAccess.close();
    }

    public boolean lockFile() throws IOException {
        this.fileLock = this.fileAccess.getChannel().tryLock(0L, 1L, false);
        return this.fileLock != null;
    }

    public boolean unlockFile() throws IOException {
        this.fileLock.release();
        this.fileLock = null;
        return true;
    }

    public boolean isLocked() {
        return this.fileLock != null;
    }

    public void init(String fileName, boolean canWrite, String password) throws IOException {
        this.fileName = fileName;
        try {
            this.fileAccess = new RandomAccessFile(fileName, canWrite ? "rw" : "r");
        }
        catch (IOException e) {
            throw new ODBRuntimeException(NeoDatisError.FILE_NOT_FOUND.addParameter(fileName));
        }
    }
}

