/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.impl.tool;

import java.sql.Date;
import java.sql.Timestamp;
import java.text.ParseException;
import org.neodatis.odb.ODBRuntimeException;
import org.neodatis.odb.core.NeoDatisError;
import org.neodatis.odb.core.layers.layer2.meta.AtomicNativeObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.ClassInfo;
import org.neodatis.odb.core.layers.layer2.meta.EnumNativeObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.NativeObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.NullNativeObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.ODBType;
import org.neodatis.odb.core.oid.OIDFactory;
import org.neodatis.tool.wrappers.NeoDatisNumber;
import org.neodatis.tool.wrappers.OdbDateFormat;

public class ObjectTool {
    public static OdbDateFormat format = new OdbDateFormat("dd/MM/yyyy HH:mm:ss:SSS");
    public static int ID_CALLER_IS_ODB_EXPLORER = 1;
    public static int ID_CALLER_IS_XML = 2;
    public static int ID_CALLER_IS_SERIALIZER = 2;

    public static Object stringToObject(int odbTypeId, String value, int caller) throws NumberFormatException, ParseException {
        Object theObject = null;
        if (value == null || value.equals("null")) {
            return new NullNativeObjectInfo(odbTypeId);
        }
        switch (odbTypeId) {
            case 20: {
                theObject = new Byte(value);
                break;
            }
            case 10: {
                theObject = value.equals("true") ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 30: {
                theObject = new Character(value.charAt(0));
                break;
            }
            case 70: {
                theObject = new Float(value);
                break;
            }
            case 80: {
                theObject = new Double(value);
                break;
            }
            case 50: {
                theObject = new Integer(value);
                break;
            }
            case 60: {
                theObject = new Long(value);
                break;
            }
            case 40: {
                theObject = new Short(value);
                break;
            }
            case 200: {
                theObject = NeoDatisNumber.createDecimalFromString(value);
                break;
            }
            case 190: {
                theObject = NeoDatisNumber.createBigIntegerFromString(value);
                break;
            }
            case 160: {
                theObject = value.equals("true") ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 150: {
                theObject = new Character(value.charAt(0));
                break;
            }
            case 170: 
            case 171: 
            case 172: {
                if (ObjectTool.callerIsOdbExplorer(caller)) {
                    theObject = format.parse(value);
                }
                if (ObjectTool.callerIsXml(caller) || ObjectTool.callerIsSerializer(caller)) {
                    theObject = new java.util.Date(Long.parseLong(value));
                }
                java.util.Date date = (java.util.Date)theObject;
                if (odbTypeId == 171) {
                    theObject = new Date(date.getTime());
                }
                if (odbTypeId != 172) break;
                theObject = new Timestamp(date.getTime());
                break;
            }
            case 130: {
                theObject = new Float(value);
                break;
            }
            case 140: {
                theObject = new Double(value);
                break;
            }
            case 110: {
                theObject = new Integer(value);
                break;
            }
            case 120: {
                theObject = new Long(value);
                break;
            }
            case 210: {
                theObject = value;
                break;
            }
            case 180: {
                theObject = OIDFactory.buildObjectOID(Long.parseLong(value));
                break;
            }
            case 181: {
                theObject = OIDFactory.buildObjectOID(Long.parseLong(value));
                break;
            }
            case 182: {
                theObject = OIDFactory.buildClassOID(Long.parseLong(value));
            }
        }
        if (theObject == null) {
            throw new ODBRuntimeException(NeoDatisError.NATIVE_TYPE_NOT_SUPPORTED.addParameter(ODBType.getNameFromId(odbTypeId)));
        }
        return theObject;
    }

    public static NativeObjectInfo stringToObjectInfo(int odbTypeId, String value, int caller, ClassInfo ci) throws NumberFormatException, ParseException {
        if (ODBType.isAtomicNative(odbTypeId)) {
            Object theObject = ObjectTool.stringToObject(odbTypeId, value, caller);
            return new AtomicNativeObjectInfo(theObject, odbTypeId);
        }
        if (ODBType.isEnum(odbTypeId)) {
            return new EnumNativeObjectInfo(ci, value);
        }
        return NullNativeObjectInfo.getInstance();
    }

    public static String atomicNativeObjectToString(AtomicNativeObjectInfo anoi, int caller) {
        if (anoi == null || anoi.isNull()) {
            return "null";
        }
        if (anoi.getObject() instanceof java.util.Date) {
            if (ObjectTool.callerIsOdbExplorer(caller)) {
                return format.format((java.util.Date)anoi.getObject());
            }
            return String.valueOf(((java.util.Date)anoi.getObject()).getTime());
        }
        return anoi.getObject().toString();
    }

    public static boolean callerIsOdbExplorer(int caller) {
        return caller == ID_CALLER_IS_ODB_EXPLORER;
    }

    public static boolean callerIsXml(int caller) {
        return caller == ID_CALLER_IS_XML;
    }

    public static boolean callerIsSerializer(int caller) {
        return caller == ID_CALLER_IS_SERIALIZER;
    }
}

