/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.impl.core.server.trigger;

import org.neodatis.odb.ODBRuntimeException;
import org.neodatis.odb.OID;
import org.neodatis.odb.ObjectRepresentation;
import org.neodatis.odb.OdbConfiguration;
import org.neodatis.odb.core.NeoDatisError;
import org.neodatis.odb.core.layers.layer1.introspector.IObjectIntrospector;
import org.neodatis.odb.core.layers.layer2.meta.AbstractObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.NonNativeObjectInfo;
import org.neodatis.odb.impl.core.layers.layer1.introspector.DefaultInstrumentationCallback;

public class DefaultObjectRepresentation
implements ObjectRepresentation {
    private final NonNativeObjectInfo nnoi;

    public DefaultObjectRepresentation(NonNativeObjectInfo nnoi) {
        this.nnoi = nnoi;
    }

    public Object getValueOf(String attributeName) {
        if (this.nnoi.isNull()) {
            throw new ODBRuntimeException(NeoDatisError.TRIGGER_CALLED_ON_NULL_OBJECT.addParameter(this.nnoi.getClassInfo().getFullClassName()).addParameter(attributeName));
        }
        return this.nnoi.getValueOf(attributeName);
    }

    public void setValueOf(String attributeName, Object value) {
        IObjectIntrospector introspector = OdbConfiguration.getCoreProvider().getLocalObjectIntrospector(null);
        AbstractObjectInfo aoi = introspector.getMetaRepresentation(value, null, true, null, new DefaultInstrumentationCallback());
        this.nnoi.setValueOf(attributeName, aoi);
    }

    public OID getOid() {
        return this.nnoi.getOid();
    }

    public String getObjectClassName() {
        return this.nnoi.getClassInfo().getFullClassName();
    }

    public final NonNativeObjectInfo getNnoi() {
        return this.nnoi;
    }
}

