/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.impl.core.server.transaction;

import java.util.Map;
import org.neodatis.odb.ODBRuntimeException;
import org.neodatis.odb.OID;
import org.neodatis.odb.OdbConfiguration;
import org.neodatis.odb.core.NeoDatisError;
import org.neodatis.odb.core.layers.layer2.meta.MetaModel;
import org.neodatis.odb.core.layers.layer2.meta.SessionMetaModel;
import org.neodatis.odb.core.layers.layer3.IStorageEngine;
import org.neodatis.odb.core.server.transaction.ISessionManager;
import org.neodatis.odb.core.transaction.ICache;
import org.neodatis.odb.impl.core.transaction.LocalSession;
import org.neodatis.odb.impl.core.transaction.ServerCache;
import org.neodatis.tool.wrappers.map.OdbHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerSession
extends LocalSession {
    protected OID[] clientIds;
    protected OID[] serverIds;
    protected Map<String, OID> classInfoIds = new OdbHashMap<String, OID>();
    protected ISessionManager sessionManager = OdbConfiguration.getCoreProvider().getClientServerSessionManager();

    public ServerSession(IStorageEngine engine, String sessionId) {
        super(engine, sessionId);
    }

    public OID[] getClientIds() {
        return this.clientIds;
    }

    public void setClientIds(OID[] clientIds) {
        this.clientIds = clientIds;
        this.serverIds = new OID[clientIds.length];
    }

    public OID[] getServerIds() {
        return this.serverIds;
    }

    public void setServerIds(OID[] serverIds) {
        this.serverIds = serverIds;
    }

    public void associateIds(OID serverId, OID clientOid) {
        for (int i = 0; i < this.clientIds.length; ++i) {
            if (clientOid.compareTo(this.clientIds[i]) != 0) continue;
            this.serverIds[i] = serverId;
            return;
        }
        throw new ODBRuntimeException(NeoDatisError.CLIENT_SERVER_CAN_NOT_ASSOCIATE_OIDS.addParameter(serverId).addParameter(clientOid));
    }

    @Override
    public ICache buildCache() {
        return new ServerCache(this);
    }

    @Override
    public MetaModel getMetaModel() {
        if (this.metaModel == null) {
            try {
                this.metaModel = new SessionMetaModel();
                if (this.getStorageEngine().getObjectReader() != null) {
                    this.metaModel = this.getStorageEngine().getObjectReader().readMetaModel(this.metaModel, true);
                }
            }
            catch (Exception e) {
                throw new ODBRuntimeException(NeoDatisError.INTERNAL_ERROR.addParameter("in ServerSession.getMetaModel"), (Throwable)e);
            }
        }
        return this.metaModel;
    }

    public void setClassInfoId(String fullClassName, OID id) {
        this.classInfoIds.put(fullClassName, id);
    }

    public Map<String, OID> getClassInfoIds() {
        return this.classInfoIds;
    }

    public void resetClassInfoIds() {
        this.classInfoIds = new OdbHashMap<String, OID>();
    }

    @Override
    public void clear() {
        super.clear();
    }

    public void finalize() {
    }
}

