/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.impl.core.layers.layer3.engine;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.neodatis.odb.DatabaseId;
import org.neodatis.odb.OID;
import org.neodatis.odb.Objects;
import org.neodatis.odb.OdbConfiguration;
import org.neodatis.odb.TransactionId;
import org.neodatis.odb.core.layers.layer2.meta.ClassInfo;
import org.neodatis.odb.core.layers.layer2.meta.ClassInfoList;
import org.neodatis.odb.core.layers.layer2.meta.MetaModel;
import org.neodatis.odb.core.layers.layer2.meta.ObjectInfoHeader;
import org.neodatis.odb.core.layers.layer3.IObjectReader;
import org.neodatis.odb.core.layers.layer3.IObjectWriter;
import org.neodatis.odb.core.layers.layer3.IStorageEngine;
import org.neodatis.odb.core.layers.layer3.engine.CheckMetaModelResult;
import org.neodatis.odb.core.layers.layer3.engine.IFileSystemInterface;
import org.neodatis.odb.core.query.IQuery;
import org.neodatis.odb.core.query.criteria.ICriterion;
import org.neodatis.odb.core.transaction.ISession;
import org.neodatis.odb.core.trigger.DeleteTrigger;
import org.neodatis.odb.core.trigger.ITriggerManager;
import org.neodatis.odb.core.trigger.InsertTrigger;
import org.neodatis.odb.core.trigger.SelectTrigger;
import org.neodatis.odb.core.trigger.UpdateTrigger;
import org.neodatis.odb.impl.core.layers.layer3.engine.StorageEngineConstant;
import org.neodatis.odb.impl.core.layers.layer3.oid.FullIDInfo;
import org.neodatis.odb.impl.core.query.criteria.CriteriaQuery;
import org.neodatis.odb.impl.core.transaction.CacheFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StorageEngineAdapter
implements IStorageEngine {
    private DatabaseId databaseId;
    protected TransactionId currentTransactionId;
    protected ITriggerManager triggerManager;
    protected boolean isClosed;

    public ClassInfo addClass(ClassInfo newClassInfo, boolean addDependentClasses) {
        return null;
    }

    @Override
    public ClassInfoList addClasses(ClassInfoList classInfoList) {
        Iterator<ClassInfo> iterator = classInfoList.getClassInfos().iterator();
        while (iterator.hasNext()) {
            this.addClass(iterator.next(), false);
        }
        return classInfoList;
    }

    public abstract void addDeleteTrigger(Class var1, DeleteTrigger var2);

    public abstract void addInsertTrigger(Class var1, InsertTrigger var2);

    public abstract void addSelectTrigger(Class var1, SelectTrigger var2);

    public abstract void addUpdateTrigger(Class var1, UpdateTrigger var2);

    @Override
    public void close() {
    }

    @Override
    public void commit() {
    }

    public long count(String fullClassName) {
        return 0L;
    }

    public long count(Class clazz) throws Exception {
        return 0L;
    }

    @Override
    public void defragmentTo(String newFileName) {
    }

    @Override
    public OID delete(Object object) {
        return null;
    }

    public OID internalDelete(ObjectInfoHeader header) {
        return null;
    }

    public void deleteObjectWithOid(long oid) throws Exception {
    }

    @Override
    public List<FullIDInfo> getAllObjectIdInfos(String objectType, boolean displayObjects) {
        return null;
    }

    @Override
    public List<Long> getAllObjectIds() {
        return null;
    }

    @Override
    public OID getCurrentIdBlockMaxOid() {
        return StorageEngineConstant.NULL_OBJECT_ID;
    }

    @Override
    public int getCurrentIdBlockNumber() {
        return 0;
    }

    @Override
    public long getCurrentIdBlockPosition() {
        return 0L;
    }

    public IFileSystemInterface getFsi() {
        return null;
    }

    @Override
    public OID getMaxOid() {
        return StorageEngineConstant.NULL_OBJECT_ID;
    }

    public MetaModel get2MetaModel() {
        return null;
    }

    public Object getObjectFromId(OID id) throws Exception {
        return null;
    }

    @Override
    public OID getObjectId(Object object, boolean throwExceptionIfDoesNotExist) {
        return null;
    }

    public <T> Objects<T> getObjectInfos(String fullClassName, IQuery query, boolean inMemory, int startIndex, int endIndex, boolean returnOjects) throws Exception {
        return null;
    }

    @Override
    public <T> Objects<T> getObjectInfos(IQuery query, boolean inMemory, int startIndex, int endIndex, boolean returnOjects) {
        return null;
    }

    @Override
    public IObjectReader getObjectReader() {
        return null;
    }

    @Override
    public IObjectWriter getObjectWriter() {
        return null;
    }

    @Override
    public <T> Objects<T> getObjects(IQuery query, boolean inMemory, int startIndex, int endIndex) {
        return null;
    }

    public <T> Objects<T> getObjects(String fullClassName, IQuery query, boolean inMemory, int startIndex, int endIndex) throws Exception {
        return null;
    }

    @Override
    public ISession getSession(boolean throwExceptionIfDoesNotExist) {
        return null;
    }

    @Override
    public int getVersion() {
        return 0;
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    public long mainStoreObject(Object object) throws Exception {
        return 0L;
    }

    public ClassInfo persistClass(ClassInfo newClassInfo, int lastClassInfoIndex, boolean addClass, boolean addDependentClasses) {
        return null;
    }

    @Override
    public void rollback() {
    }

    @Override
    public void setCurrentIdBlockInfos(long currentBlockPosition, int currentBlockNumber, OID maxId) {
    }

    public void setDatabaseId(long[] databaseId) {
    }

    @Override
    public void setLastODBCloseStatus(boolean lastCloseStatus) {
    }

    @Override
    public void setMetaModel(MetaModel metaModel) {
    }

    @Override
    public void setNbClasses(long nbClasses) {
    }

    @Override
    public void setVersion(int version) {
    }

    @Override
    public TransactionId getCurrentTransactionId() {
        return this.currentTransactionId;
    }

    @Override
    public void setCurrentTransactionId(TransactionId transactionId) {
        this.currentTransactionId = transactionId;
    }

    @Override
    public void setDatabaseId(DatabaseId databaseId) {
        this.databaseId = databaseId;
    }

    @Override
    public DatabaseId getDatabaseId() {
        return this.databaseId;
    }

    @Override
    public void disconnect(Object object) {
        if (OdbConfiguration.reconnectObjectsToSession()) {
            CacheFactory.getCrossSessionCache(this.getBaseIdentification().getIdentification()).removeObject(object);
        }
    }

    @Override
    public void reconnect(Object object) {
    }

    @Override
    public ITriggerManager getTriggerManager() {
        return this.triggerManager;
    }

    @Override
    public void addDeleteTriggerFor(String className, DeleteTrigger trigger) {
        this.triggerManager.addDeleteTriggerFor(className, trigger);
    }

    @Override
    public void addInsertTriggerFor(String className, InsertTrigger trigger) {
        this.triggerManager.addInsertTriggerFor(className, trigger);
    }

    @Override
    public void addSelectTriggerFor(String className, SelectTrigger trigger) {
        this.triggerManager.addSelectTriggerFor(className, trigger);
    }

    @Override
    public void addUpdateTriggerFor(String className, UpdateTrigger trigger) {
        this.triggerManager.addUpdateTriggerFor(className, trigger);
    }

    @Override
    public abstract <T> Objects<T> getObjects(Class var1, boolean var2, int var3, int var4);

    @Override
    public CheckMetaModelResult checkMetaModelCompatibility(Map<String, ClassInfo> currentCIs) {
        return null;
    }

    @Override
    public CriteriaQuery criteriaQuery(Class clazz, ICriterion criterion) {
        CriteriaQuery q = new CriteriaQuery(clazz, criterion);
        q.setStorageEngine(this);
        if (criterion != null) {
            criterion.ready();
        }
        return q;
    }

    @Override
    public CriteriaQuery criteriaQuery(Class clazz) {
        CriteriaQuery q = new CriteriaQuery(clazz);
        q.setStorageEngine(this);
        return q;
    }
}

