/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.core.server.connection;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.neodatis.odb.ODBRuntimeException;
import org.neodatis.odb.OdbConfiguration;
import org.neodatis.odb.core.NeoDatisError;
import org.neodatis.odb.core.server.connection.ClientServerConnection;
import org.neodatis.odb.core.server.layers.layer3.IODBServerExt;
import org.neodatis.odb.core.server.layers.layer3.engine.IMessageStreamer;
import org.neodatis.odb.core.server.layers.layer3.engine.Message;
import org.neodatis.tool.DLogger;
import org.neodatis.tool.wrappers.OdbRunnable;
import org.neodatis.tool.wrappers.OdbString;
import org.neodatis.tool.wrappers.OdbThread;

public class DefaultConnectionThread
extends ClientServerConnection
implements OdbRunnable {
    private static final String LOG_ID = "DefaultConnectionThread";
    private Socket socketConnection;
    private String name;
    private IMessageStreamer messageStreamer;

    public DefaultConnectionThread(IODBServerExt server, Socket connection, boolean automaticallyCreateDatabase) {
        super(server, automaticallyCreateDatabase);
        this.socketConnection = connection;
    }

    public void run() {
        OutputStream out = null;
        InputStream in = null;
        String messageType = null;
        try {
            this.socketConnection.setTcpNoDelay(true);
            this.connectionIsUp = true;
            out = this.socketConnection.getOutputStream();
            in = this.socketConnection.getInputStream();
            this.messageStreamer = OdbConfiguration.getCoreProvider().getMessageStreamer(this.socketConnection);
            Message message = null;
            Message rmessage = null;
            do {
                message = null;
                message = this.messageStreamer.read();
                if (message != null) {
                    messageType = message.getClass().getName();
                    rmessage = this.manageMessage(message);
                    this.messageStreamer.write(rmessage);
                    continue;
                }
                messageType = "Null Message";
            } while (this.connectionIsUp && message != null);
        }
        catch (EOFException eoe) {
            DLogger.error("Thread " + OdbThread.getCurrentThreadName() + ": Error in connection thread baseId=" + this.baseIdentifier + " and cid=" + this.connectionId + " for message of type " + messageType + " : Client has terminated the connection!");
            this.connectionIsUp = false;
        }
        catch (Throwable e) {
            String m = OdbString.exceptionToString(e, false);
            DLogger.error("Thread " + OdbThread.getCurrentThreadName() + ": Error in connection thread baseId=" + this.baseIdentifier + " and cid=" + this.connectionId + " for message of type " + messageType + " : \n" + m);
            this.connectionIsUp = false;
            throw new ODBRuntimeException(NeoDatisError.NET_SERIALISATION_ERROR.addParameter(e.getMessage()).addParameter(m));
        }
        finally {
            try {
                this.messageStreamer.close();
                this.socketConnection.close();
            }
            catch (IOException e) {
                DLogger.error("Error while closing socket - connection thread baseId=" + this.baseIdentifier + " and cid=" + this.connectionId + ": \n" + OdbString.exceptionToString(e, false));
            }
            if (this.debug) {
                DLogger.info("Exiting thread " + OdbThread.getCurrentThreadName());
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void clearMessageStreamerCache() {
        this.messageStreamer.clearCache();
    }
}

