/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.core.layers.layer3.engine;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.neodatis.odb.DatabaseId;
import org.neodatis.odb.ODBAuthenticationRuntimeException;
import org.neodatis.odb.ODBRuntimeException;
import org.neodatis.odb.OID;
import org.neodatis.odb.OdbConfiguration;
import org.neodatis.odb.TransactionId;
import org.neodatis.odb.Values;
import org.neodatis.odb.core.NeoDatisError;
import org.neodatis.odb.core.layers.layer1.introspector.IClassIntrospector;
import org.neodatis.odb.core.layers.layer1.introspector.IIntrospectionCallback;
import org.neodatis.odb.core.layers.layer1.introspector.IObjectIntrospector;
import org.neodatis.odb.core.layers.layer2.meta.ClassInfo;
import org.neodatis.odb.core.layers.layer2.meta.ClassInfoCompareResult;
import org.neodatis.odb.core.layers.layer2.meta.ClassInfoList;
import org.neodatis.odb.core.layers.layer2.meta.MetaModel;
import org.neodatis.odb.core.layers.layer2.meta.NonNativeObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.ODBType;
import org.neodatis.odb.core.layers.layer2.meta.ObjectInfoHeader;
import org.neodatis.odb.core.layers.layer2.meta.SessionMetaModel;
import org.neodatis.odb.core.layers.layer3.IBaseIdentification;
import org.neodatis.odb.core.layers.layer3.ICommitListener;
import org.neodatis.odb.core.layers.layer3.IObjectReader;
import org.neodatis.odb.core.layers.layer3.IObjectWriter;
import org.neodatis.odb.core.layers.layer3.IRefactorManager;
import org.neodatis.odb.core.layers.layer3.IStorageEngine;
import org.neodatis.odb.core.layers.layer3.engine.AbstractStorageEngineReader;
import org.neodatis.odb.core.layers.layer3.engine.CheckMetaModelResult;
import org.neodatis.odb.core.query.IValuesQuery;
import org.neodatis.odb.core.query.criteria.ICriterion;
import org.neodatis.odb.core.transaction.ICache;
import org.neodatis.odb.core.transaction.ICrossSessionCache;
import org.neodatis.odb.core.transaction.ISession;
import org.neodatis.odb.core.trigger.DeleteTrigger;
import org.neodatis.odb.core.trigger.ITriggerManager;
import org.neodatis.odb.core.trigger.InsertTrigger;
import org.neodatis.odb.core.trigger.SelectTrigger;
import org.neodatis.odb.core.trigger.UpdateTrigger;
import org.neodatis.odb.impl.core.layers.layer1.introspector.DefaultInstrospectionCallbackForStore;
import org.neodatis.odb.impl.core.layers.layer1.introspector.GetDependentObjectIntrospectingCallback;
import org.neodatis.odb.impl.core.layers.layer3.engine.FileMutex;
import org.neodatis.odb.impl.core.layers.layer3.oid.FullIDInfo;
import org.neodatis.odb.impl.core.query.criteria.CriteriaQuery;
import org.neodatis.odb.impl.core.query.values.ValuesCriteriaQuery;
import org.neodatis.odb.impl.core.transaction.CacheFactory;
import org.neodatis.tool.DLogger;
import org.neodatis.tool.wrappers.OdbString;
import org.neodatis.tool.wrappers.OdbSystem;
import org.neodatis.tool.wrappers.OdbTime;
import org.neodatis.tool.wrappers.list.IOdbList;
import org.neodatis.tool.wrappers.list.OdbArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractStorageEngine
extends AbstractStorageEngineReader
implements IStorageEngine {
    private static final String LOG_ID = "LocalStorageEngine";
    private int version;
    private DatabaseId databaseId;
    private IObjectWriter objectWriter;
    protected IObjectIntrospector objectIntrospector;
    protected IClassIntrospector classIntrospector;
    private long nbClasses;
    private boolean lastOdbCloseStatus;
    private long currentIdBlockPosition;
    private int currentIdBlockNumber;
    private OID currentIdBlockMaxOid;
    protected ITriggerManager triggerManager;
    protected IOdbList<ICommitListener> commitListeners;
    protected boolean isLocal;
    protected TransactionId currentTransactionId;
    protected IIntrospectionCallback introspectionCallbackForInsert;
    protected IIntrospectionCallback introspectionCallbackForUpdate;

    public AbstractStorageEngine(IBaseIdentification parameters) {
        this.provider = OdbConfiguration.getCoreProvider();
        this.baseIdentification = parameters;
        this.init();
    }

    protected void init() {
        this.checkRuntimeCompatibility();
        this.isClosed = false;
        this.isLocal = this.baseIdentification.isLocal();
        boolean isNewDatabase = this.isNewDatabase();
        this.commitListeners = new OdbArrayList<ICommitListener>();
        this.classIntrospector = this.provider.getClassIntrospector();
        ISession session = this.buildDefaultSession();
        this.objectWriter = this.buildObjectWriter();
        this.objectWriter.init2();
        this.objectReader = this.buildObjectReader();
        this.addSession(session, false);
        if (isNewDatabase) {
            this.objectWriter.createEmptyDatabaseHeader(OdbTime.getCurrentTimeInMs(), this.baseIdentification.getUserName(), this.baseIdentification.getPassword());
        } else {
            try {
                this.getObjectReader().readDatabaseHeader(this.baseIdentification.getUserName(), this.baseIdentification.getPassword());
            }
            catch (ODBAuthenticationRuntimeException e) {
                this.close();
                throw e;
            }
        }
        this.objectWriter.afterInit();
        this.objectIntrospector = this.buildObjectIntrospector();
        this.triggerManager = this.buildTriggerManager();
        MetaModel metaModel = this.getMetaModel();
        if (OdbConfiguration.checkModelCompatibility()) {
            this.checkMetaModelCompatibility(this.classIntrospector.instrospect(metaModel.getAllClasses()));
        }
        FileMutex.getInstance().openFile(this.getStorageDeviceName());
        this.objectWriter.writeLastTransactionId(this.getCurrentTransactionId());
        this.objectWriter.setTriggerManager(this.triggerManager);
        this.introspectionCallbackForInsert = new DefaultInstrospectionCallbackForStore(this, this.triggerManager, false);
        this.introspectionCallbackForUpdate = new DefaultInstrospectionCallbackForStore(this, this.triggerManager, true);
    }

    @Override
    public void addSession(ISession session, boolean readMetamodel) {
        session.setFileSystemInterfaceToApplyTransaction(this.objectWriter.getFsi());
        if (readMetamodel) {
            MetaModel metaModel = null;
            try {
                this.objectReader.readDatabaseHeader(this.baseIdentification.getUserName(), this.baseIdentification.getPassword());
            }
            catch (ODBAuthenticationRuntimeException e) {
                this.close();
                throw e;
            }
            metaModel = new SessionMetaModel();
            session.setMetaModel(metaModel);
            metaModel = this.objectReader.readMetaModel(metaModel, true);
            this.objectWriter.writeLastTransactionId(this.getCurrentTransactionId());
        }
    }

    @Override
    public CheckMetaModelResult checkMetaModelCompatibility(Map<String, ClassInfo> currentCIs) {
        ClassInfo persistedCI2 = null;
        ClassInfo currentCI = null;
        ClassInfoCompareResult result = null;
        CheckMetaModelResult checkMetaModelResult = new CheckMetaModelResult();
        for (ClassInfo persistedCI2 : this.getMetaModel().getUserClasses()) {
            result = persistedCI2.extractDifferences(currentCI = currentCIs.get(persistedCI2.getFullClassName()), true);
            if (!result.isCompatible()) {
                throw new ODBRuntimeException(NeoDatisError.INCOMPATIBLE_METAMODEL.addParameter(result.toString()));
            }
            if (!result.hasCompatibleChanges()) continue;
            checkMetaModelResult.add(result);
        }
        for (ClassInfo persistedCI2 : this.getMetaModel().getSystemClasses()) {
            result = persistedCI2.extractDifferences(currentCI = currentCIs.get(persistedCI2.getFullClassName()), true);
            if (!result.isCompatible()) {
                throw new ODBRuntimeException(NeoDatisError.INCOMPATIBLE_METAMODEL.addParameter(result.toString()));
            }
            if (!result.hasCompatibleChanges()) continue;
            checkMetaModelResult.add(result);
        }
        for (int i = 0; i < checkMetaModelResult.size(); ++i) {
            result = checkMetaModelResult.getResults().get(i);
            DLogger.info("Class " + result.getFullClassName() + " has changed :");
            DLogger.info(result.toString());
        }
        if (!checkMetaModelResult.getResults().isEmpty()) {
            this.updateMetaModel();
            checkMetaModelResult.setModelHasBeenUpdated(true);
        }
        return checkMetaModelResult;
    }

    public void checkRuntimeCompatibility() {
        if (!OdbConfiguration.checkRuntimeVersion()) {
            return;
        }
        String runtimeVersion = null;
        try {
            runtimeVersion = OdbSystem.getProperty("java.version");
        }
        catch (Exception e) {
            // empty catch block
        }
        if (runtimeVersion != null) {
            String os = OdbSystem.getProperty("os.name");
            String osArc = OdbSystem.getProperty("os.arch");
            String javaVendor = OdbSystem.getProperty("java.vendor");
            if (javaVendor == null) {
                DLogger.info("Current JVM does not have 'java.vendor' property defined => unable to check JVM runtime compatibility");
                return;
            }
            if (javaVendor.equals("The Android Project")) {
                return;
            }
            if (runtimeVersion == null || runtimeVersion.length() < 3) {
                DLogger.info("Current JVM does not have correct vava version => unable to check JVM runtime compatibility");
                return;
            }
            double version = Float.parseFloat(OdbString.substring(runtimeVersion, 0, 3));
            if (version < 1.5) {
                throw new ODBRuntimeException(NeoDatisError.INCOMPATIBLE_JAVA_VM.addParameter(runtimeVersion));
            }
        }
    }

    public void updateMetaModel() {
        MetaModel metaModel = this.getMetaModel();
        DLogger.info("Automatic refactoring : updating meta model");
        Iterator<ClassInfo> iterator = metaModel.getUserClasses().iterator();
        while (iterator.hasNext()) {
            this.objectWriter.updateClassInfo(iterator.next(), true);
        }
        iterator = metaModel.getSystemClasses().iterator();
        while (iterator.hasNext()) {
            this.objectWriter.updateClassInfo(iterator.next(), true);
        }
    }

    private String getStorageDeviceName() {
        return this.baseIdentification.getIdentification();
    }

    private boolean isNewDatabase() {
        return this.baseIdentification.isNew();
    }

    @Override
    public OID store(Object object) {
        return this.store(null, object);
    }

    @Override
    public OID store(OID oid, Object object) {
        if (this.isClosed) {
            throw new ODBRuntimeException(NeoDatisError.ODB_IS_CLOSED.addParameter(this.baseIdentification.getIdentification()));
        }
        OID newOid = this.internalStore(oid, object);
        this.getSession(true).getCache().clearInsertingObjects();
        return newOid;
    }

    protected OID internalStore(Object object) {
        return this.internalStore(null, object);
    }

    protected OID internalStore(OID oid, Object object) {
        NonNativeObjectInfo nnoi;
        if (this.getSession(true).isRollbacked()) {
            throw new ODBRuntimeException(NeoDatisError.ODB_HAS_BEEN_ROLLBACKED.addParameter(this.getBaseIdentification().toString()));
        }
        if (object == null) {
            throw new ODBRuntimeException(NeoDatisError.ODB_CAN_NOT_STORE_NULL_OBJECT);
        }
        Class<?> clazz = object.getClass();
        if (ODBType.isNative(clazz)) {
            throw new ODBRuntimeException(NeoDatisError.ODB_CAN_NOT_STORE_NATIVE_OBJECT_DIRECTLY.addParameter(clazz.getName()).addParameter(ODBType.getFromClass(clazz).getName()).addParameter(clazz.getName()));
        }
        ClassInfo ci = null;
        String className = clazz.getName();
        if (this.getMetaModel().existClass(className)) {
            ci = this.getMetaModel().getClassInfo(className, true);
        } else {
            ClassInfoList ciList = this.classIntrospector.introspect(object.getClass(), true);
            this.objectWriter.addClasses(ciList);
            ci = ciList.getMainClassInfo();
        }
        boolean mustUpdate = false;
        ICache cache = this.getSession(true).getCache();
        if (object != null) {
            OID cacheOid = cache.idOfInsertingObject(object);
            if (cacheOid != null) {
                return cacheOid;
            }
            mustUpdate = cache.existObject(object);
        }
        IIntrospectionCallback callback = this.introspectionCallbackForInsert;
        if (mustUpdate) {
            callback = this.introspectionCallbackForUpdate;
        }
        boolean bl = mustUpdate = (nnoi = (NonNativeObjectInfo)this.objectIntrospector.getMetaRepresentation(object, ci, true, null, callback)).getOid() != null;
        if (mustUpdate) {
            return this.objectWriter.updateNonNativeObjectInfo(nnoi, false);
        }
        return this.objectWriter.insertNonNativeObject(oid, nnoi, true);
    }

    @Override
    public void deleteObjectWithOid(OID oid) {
        ObjectInfoHeader oih = null;
        ISession lsession = this.getSession(true);
        ICache cache = lsession.getCache();
        oih = cache.getObjectInfoHeaderFromOid(oid, false);
        if (oih == null) {
            oih = this.objectReader.readObjectInfoHeaderFromOid(oid, true);
        }
        Object object = null;
        if (OdbConfiguration.reconnectObjectsToSession()) {
            CacheFactory.getCrossSessionCache(this.getBaseIdentification().getIdentification()).removeOid(oid);
        }
        this.objectWriter.delete(oih);
        cache.removeObjectWithOid(oih.getOid());
    }

    @Override
    public OID delete(Object object) {
        boolean throwExceptionIfNotInCache;
        ISession lsession = this.getSession(true);
        if (lsession.isRollbacked()) {
            throw new ODBRuntimeException(NeoDatisError.ODB_HAS_BEEN_ROLLBACKED.addParameter(this.baseIdentification.toString()));
        }
        if (object == null) {
            throw new ODBRuntimeException(NeoDatisError.ODB_CAN_NOT_DELETE_NULL_OBJECT);
        }
        ICache cache = lsession.getCache();
        ObjectInfoHeader header = cache.getObjectInfoHeaderFromObject(object, throwExceptionIfNotInCache = false);
        if (header == null) {
            OID cachedOid = cache.getOid(object, false);
            if (cachedOid == null && OdbConfiguration.reconnectObjectsToSession()) {
                ICrossSessionCache crossSessionCache = CacheFactory.getCrossSessionCache(this.getBaseIdentification().getIdentification());
                cachedOid = crossSessionCache.getOid(object);
            }
            if (cachedOid == null) {
                throw new ODBRuntimeException(NeoDatisError.OBJECT_DOES_NOT_EXIST_IN_CACHE_FOR_DELETE.addParameter(object.getClass().getName()).addParameter(object.toString()));
            }
            header = this.objectReader.readObjectInfoHeaderFromOid(cachedOid, false);
        }
        this.triggerManager.manageDeleteTriggerBefore(object.getClass().getName(), object, header.getOid());
        OID oid = this.objectWriter.delete(header);
        this.triggerManager.manageDeleteTriggerAfter(object.getClass().getName(), object, oid);
        cache.removeObjectWithOid(header.getOid());
        if (OdbConfiguration.reconnectObjectsToSession()) {
            CacheFactory.getCrossSessionCache(this.getBaseIdentification().getIdentification()).removeObject(object);
        }
        return oid;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getMetaModel().toString());
        return buffer.toString();
    }

    @Override
    public void close() {
        if (this.isClosed) {
            throw new ODBRuntimeException(NeoDatisError.ODB_IS_CLOSED.addParameter(this.baseIdentification.getIdentification()));
        }
        ISession lsession = this.getSession(this.isLocal);
        if (this.baseIdentification.canWrite()) {
            this.objectWriter.writeLastODBCloseStatus(true, false);
        }
        this.objectWriter.flush();
        if (this.isLocal && lsession.transactionIsPending()) {
            throw new ODBRuntimeException(NeoDatisError.TRANSACTION_IS_PENDING.addParameter(lsession.getId()));
        }
        this.isClosed = true;
        this.objectReader.close();
        this.objectWriter.close();
        FileMutex.getInstance().releaseFile(this.getStorageDeviceName());
        if (lsession != null) {
            lsession.close();
        }
        if (this.objectIntrospector != null) {
            this.objectIntrospector.clear();
            this.objectIntrospector = null;
        }
        this.provider.removeLocalTriggerManager(this);
    }

    @Override
    public long count(CriteriaQuery query) {
        if (this.isClosed) {
            throw new ODBRuntimeException(NeoDatisError.ODB_IS_CLOSED.addParameter(this.baseIdentification.getIdentification()));
        }
        IValuesQuery q = new ValuesCriteriaQuery(query).count("count");
        Values values = this.getValues(q, -1, -1);
        Long count = (Long)values.nextValues().getByIndex(0);
        return count;
    }

    @Override
    public IObjectReader getObjectReader() {
        return this.objectReader;
    }

    @Override
    public IObjectWriter getObjectWriter() {
        return this.objectWriter;
    }

    @Override
    public void commit() {
        if (this.isClosed()) {
            throw new ODBRuntimeException(NeoDatisError.ODB_IS_CLOSED.addParameter(this.baseIdentification.getIdentification()));
        }
        this.getSession(true).commit();
        this.objectWriter.flush();
    }

    @Override
    public void rollback() {
        this.getSession(true).rollback();
    }

    @Override
    public OID getObjectId(Object object, boolean throwExceptionIfDoesNotExist) {
        OID oid = null;
        if (object != null) {
            ICrossSessionCache cache;
            oid = this.getSession(true).getCache().getOid(object, false);
            if (oid == null && OdbConfiguration.reconnectObjectsToSession() && (oid = (cache = CacheFactory.getCrossSessionCache(this.getBaseIdentification().getIdentification())).getOid(object)) != null) {
                return oid;
            }
            oid = this.getSession(true).getCache().getOid(object, false);
            if (oid == null && throwExceptionIfDoesNotExist) {
                throw new ODBRuntimeException(NeoDatisError.UNKNOWN_OBJECT_TO_GET_OID.addParameter(object.toString()));
            }
            return oid;
        }
        throw new ODBRuntimeException(NeoDatisError.ODB_CAN_NOT_RETURN_OID_OF_NULL_OBJECT);
    }

    @Override
    public Object getObjectFromOid(OID oid) {
        if (oid == null) {
            throw new ODBRuntimeException(NeoDatisError.CAN_NOT_GET_OBJECT_FROM_NULL_OID);
        }
        NonNativeObjectInfo nnoi = this.getObjectReader().readNonNativeObjectInfoFromOid(null, oid, true, true);
        if (nnoi.isDeletedObject()) {
            throw new ODBRuntimeException(NeoDatisError.OBJECT_IS_MARKED_AS_DELETED_FOR_OID.addParameter(oid));
        }
        Object o = nnoi.getObject();
        if (o == null) {
            o = this.getObjectReader().getInstanceBuilder().buildOneInstance(nnoi);
        }
        ISession lsession = this.getSession(true);
        lsession.getCache().addObject(nnoi.getOid(), o, nnoi.getHeader());
        lsession.getTmpCache().clearObjectInfos();
        return o;
    }

    @Override
    public NonNativeObjectInfo getMetaObjectFromOid(OID oid) {
        NonNativeObjectInfo nnoi = this.getObjectReader().readNonNativeObjectInfoFromOid(null, oid, true, false);
        this.getSession(true).getTmpCache().clearObjectInfos();
        return nnoi;
    }

    @Override
    public ObjectInfoHeader getObjectInfoHeaderFromOid(OID oid, boolean useCache) {
        return this.getObjectReader().readObjectInfoHeaderFromOid(oid, useCache);
    }

    @Override
    public List<Long> getAllObjectIds() {
        return this.objectReader.getAllIds((byte)1);
    }

    @Override
    public List<FullIDInfo> getAllObjectIdInfos(String objectType, boolean displayObjects) {
        return this.objectReader.getAllIdInfos(objectType, (byte)1, displayObjects);
    }

    @Override
    public void setVersion(int version) {
        this.version = version;
    }

    @Override
    public void setDatabaseId(DatabaseId databaseId) {
        this.databaseId = databaseId;
    }

    @Override
    public void setNbClasses(long nbClasses) {
        this.nbClasses = nbClasses;
    }

    @Override
    public void setLastODBCloseStatus(boolean lastCloseStatus) {
        this.lastOdbCloseStatus = lastCloseStatus;
    }

    @Override
    public void setCurrentIdBlockInfos(long currentBlockPosition, int currentBlockNumber, OID maxId) {
        this.currentIdBlockPosition = currentBlockPosition;
        this.currentIdBlockNumber = currentBlockNumber;
        this.currentIdBlockMaxOid = maxId;
    }

    @Override
    public int getCurrentIdBlockNumber() {
        return this.currentIdBlockNumber;
    }

    @Override
    public long getCurrentIdBlockPosition() {
        return this.currentIdBlockPosition;
    }

    @Override
    public DatabaseId getDatabaseId() {
        return this.databaseId;
    }

    @Override
    public OID getCurrentIdBlockMaxOid() {
        return this.currentIdBlockMaxOid;
    }

    @Override
    public OID getMaxOid() {
        return this.objectWriter.getIdManager().consultNextOid();
    }

    @Override
    public void setMetaModel(MetaModel metaModel2) {
        ClassInfo ci = null;
        SessionMetaModel metaModel = new SessionMetaModel();
        this.getSession(true).setMetaModel(metaModel);
        Iterator iterator = metaModel2.getAllClasses().iterator();
        while (iterator.hasNext()) {
            this.getMetaModel().addClass((ClassInfo)iterator.next());
        }
        iterator = metaModel.getAllClasses().iterator();
        int i = 0;
        while (iterator.hasNext()) {
            ci = (ClassInfo)iterator.next();
            if (ci.getPosition() == -1L) {
                this.objectWriter.persistClass(ci, i == 0 ? -2 : i - 1, false, false);
            }
            ++i;
        }
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public IBaseIdentification getBaseIdentification() {
        return this.baseIdentification;
    }

    @Override
    public OID writeObjectInfo(OID oid, NonNativeObjectInfo aoi, long position, boolean updatePointers) {
        return this.objectWriter.writeNonNativeObjectInfo(oid, aoi, position, updatePointers, true);
    }

    @Override
    public OID updateObject(NonNativeObjectInfo nnoi, boolean forceUpdate) {
        return this.objectWriter.updateNonNativeObjectInfo(nnoi, forceUpdate);
    }

    @Override
    public Values getValues(IValuesQuery query, int startIndex, int endIndex) {
        if (this.isClosed) {
            throw new ODBRuntimeException(NeoDatisError.ODB_IS_CLOSED.addParameter(this.baseIdentification.getIdentification()));
        }
        return this.objectReader.getValues(query, startIndex, endIndex);
    }

    @Override
    public void addCommitListener(ICommitListener commitListener) {
        this.commitListeners.add(commitListener);
    }

    @Override
    public IOdbList<ICommitListener> getCommitListeners() {
        return this.commitListeners;
    }

    @Override
    public IRefactorManager getRefactorManager() {
        return this.provider.getRefactorManager(this);
    }

    @Override
    public void resetCommitListeners() {
        this.commitListeners.clear();
    }

    @Override
    public boolean isLocal() {
        return this.isLocal;
    }

    @Override
    public TransactionId getCurrentTransactionId() {
        return this.currentTransactionId;
    }

    @Override
    public void setCurrentTransactionId(TransactionId transactionId) {
        this.currentTransactionId = transactionId;
    }

    @Override
    public void disconnect(Object object) {
        this.getSession(true).removeObjectFromCache(object);
        if (OdbConfiguration.reconnectObjectsToSession()) {
            CacheFactory.getCrossSessionCache(this.getBaseIdentification().getIdentification()).removeObject(object);
        }
    }

    @Override
    public void reconnect(Object object) {
        if (object == null) {
            throw new ODBRuntimeException(NeoDatisError.RECONNECT_CAN_RECONNECT_NULL_OBJECT);
        }
        ICrossSessionCache crossSessionCache = CacheFactory.getCrossSessionCache(this.getBaseIdentification().getIdentification());
        OID oid = crossSessionCache.getOid(object);
        if (oid == null) {
            throw new ODBRuntimeException(NeoDatisError.CROSS_SESSION_CACHE_NULL_OID_FOR_OBJECT.addParameter(object));
        }
        ObjectInfoHeader oih = this.objectReader.readObjectInfoHeaderFromOid(oid, false);
        this.getSession(true).addObjectToCache(oid, object, oih);
        GetDependentObjectIntrospectingCallback getObjectsCallback = new GetDependentObjectIntrospectingCallback();
        ClassInfo ci = this.getSession(true).getMetaModel().getClassInfoFromId(oih.getClassInfoId());
        this.objectIntrospector.getMetaRepresentation(object, ci, true, null, getObjectsCallback);
        Collection<Object> dependentObjects = getObjectsCallback.getObjects();
        for (Object o : dependentObjects) {
            if (o == null) continue;
            oid = crossSessionCache.getOid(o);
            if (oid == null) {
                throw new ODBRuntimeException(NeoDatisError.CROSS_SESSION_CACHE_NULL_OID_FOR_OBJECT.addParameter(o));
            }
            oih = this.objectReader.readObjectInfoHeaderFromOid(oid, false);
            this.getSession(true).addObjectToCache(oid, o, oih);
        }
    }

    @Override
    public ITriggerManager getTriggerManager() {
        return this.triggerManager;
    }

    @Override
    public void addDeleteTriggerFor(String className, DeleteTrigger trigger) {
        this.triggerManager.addDeleteTriggerFor(className, trigger);
    }

    @Override
    public void addInsertTriggerFor(String className, InsertTrigger trigger) {
        this.triggerManager.addInsertTriggerFor(className, trigger);
    }

    @Override
    public void addSelectTriggerFor(String className, SelectTrigger trigger) {
        this.triggerManager.addSelectTriggerFor(className, trigger);
    }

    @Override
    public void addUpdateTriggerFor(String className, UpdateTrigger trigger) {
        this.triggerManager.addUpdateTriggerFor(className, trigger);
    }

    @Override
    public IObjectIntrospector getObjectIntrospector() {
        return this.objectIntrospector;
    }

    @Override
    public CriteriaQuery criteriaQuery(Class clazz, ICriterion criterion) {
        CriteriaQuery q = new CriteriaQuery(clazz, criterion);
        q.setStorageEngine(this);
        if (criterion != null) {
            criterion.ready();
        }
        return q;
    }

    @Override
    public CriteriaQuery criteriaQuery(Class clazz) {
        CriteriaQuery q = new CriteriaQuery(clazz);
        q.setStorageEngine(this);
        return q;
    }
}

