/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb;

import java.io.UnsupportedEncodingException;
import java.util.Map;
import org.neodatis.odb.ODBRuntimeException;
import org.neodatis.odb.core.ICoreProvider;
import org.neodatis.odb.core.NeoDatisError;
import org.neodatis.odb.core.query.execution.IQueryExecutorCallback;
import org.neodatis.odb.impl.DefaultCoreProvider;
import org.neodatis.odb.impl.core.layers.layer3.engine.DefaultByteArrayConverter;
import org.neodatis.odb.impl.core.server.layers.layer3.engine.DefaultMessageStreamer;
import org.neodatis.tool.wrappers.NeoDatisClassLoader;
import org.neodatis.tool.wrappers.io.OdbFileIO;
import org.neodatis.tool.wrappers.map.OdbHashMap;

public class OdbConfiguration {
    private static boolean coreProviderInit = false;
    private static boolean debugEnabled = false;
    private static boolean logAll = false;
    private static int debugLevel = 100;
    private static Map<String, String> logIds = null;
    private static boolean infoEnabled = false;
    private static boolean enableAfterWriteChecking = false;
    private static int maxNumberOfWriteObjectPerTransaction = 10000;
    private static long maxNumberOfObjectInCache = 3000000L;
    private static int defaultBufferSizeForData = 16384;
    private static int defaultBufferSizeForTransaction = 16384;
    private static int nbBuffers = 5;
    private static boolean useMultiBuffer = true;
    private static boolean automaticCloseFileOnExit = false;
    private static boolean saveHistory = false;
    private static String defaultDatabaseCharacterEncoding;
    private static String databaseCharacterEncoding;
    private static boolean throwExceptionWhenInconsistencyFound;
    private static final int NB_IDS_PER_BLOCK = 1000;
    private static final int ID_BLOCK_REPETITION_SIZE = 18;
    private static int idBlockSize;
    private static boolean inPlaceUpdate;
    private static int stringSpaceReserveFactor;
    private static boolean checkModelCompatibility;
    private static boolean monitorMemory;
    private static boolean enableEmptyConstructorCreation;
    private static boolean retryIfFileIsLocked;
    private static int numberOfRetryToOpenFile;
    private static long retryTimeout;
    private static long defaultFileCreationTime;
    private static boolean automaticallyIncreaseCacheSize;
    private static boolean useCache;
    private static boolean logServerStartupAndShutdown;
    private static boolean logServerConnections;
    private static int defaultIndexBTreeDegree;
    private static boolean useLazyCache;
    private static boolean displayWarnings;
    private static IQueryExecutorCallback queryExecutorCallback;
    private static int scaleForAverageDivision;
    private static int roundTypeForAverageDivision;
    private static Class ioClass;
    private static String encryptionPassword;
    private static ICoreProvider coreProvider;
    private static boolean checkRuntimeVersion;
    private static boolean reconnectObjectsToSession;
    private static ClassLoader classLoader;
    private static Class messageStreamerClass;
    private static boolean useIndex;
    private static boolean shareSameVmConnectionMultiThread;
    private static boolean lockObjectsOnSelect;

    public static boolean reconnectObjectsToSession() {
        return reconnectObjectsToSession;
    }

    public static void setAutoReconnectObjectsToSession(boolean autoReconnectObjectsToSession) {
        reconnectObjectsToSession = autoReconnectObjectsToSession;
    }

    public static void setReconnectObjectsToSession(boolean reconnectObjectsToSession) {
        OdbConfiguration.reconnectObjectsToSession = reconnectObjectsToSession;
    }

    public static int getDefaultBufferSizeForData() {
        return defaultBufferSizeForData;
    }

    public static void setDefaultBufferSizeForData(int defaultBufferSize) {
        defaultBufferSizeForData = defaultBufferSize;
    }

    public static void addLogId(String logId) {
        if (logIds == null) {
            logIds = new OdbHashMap<String, String>();
        }
        logIds.put(logId, logId);
    }

    public static void removeLogId(String logId) {
        if (logIds == null) {
            logIds = new OdbHashMap<String, String>();
        }
        logIds.remove(logId);
    }

    public static boolean isDebugEnabled(String logId) {
        if (!debugEnabled) {
            return false;
        }
        if (logAll) {
            return true;
        }
        if (logIds == null || logIds.size() == 0) {
            return false;
        }
        return logIds.containsKey(logId);
    }

    public static void setDebugEnabled(int level, boolean debug) {
        debugEnabled = debug;
        debugLevel = level;
    }

    public static boolean isEnableAfterWriteChecking() {
        return enableAfterWriteChecking;
    }

    public static boolean isInfoEnabled() {
        return infoEnabled;
    }

    public static boolean isInfoEnabled(String logId) {
        if (logAll) {
            return true;
        }
        if (logIds == null || logIds.size() == 0) {
            return false;
        }
        return logIds.containsKey(logId);
    }

    public static void setInfoEnabled(boolean infoEnabled) {
        OdbConfiguration.infoEnabled = infoEnabled;
    }

    public static void setEnableAfterWriteChecking(boolean enableAfterWriteChecking) {
        OdbConfiguration.enableAfterWriteChecking = enableAfterWriteChecking;
    }

    public static int getMaxNumberOfWriteObjectPerTransaction() {
        return maxNumberOfWriteObjectPerTransaction;
    }

    public static void setMaxNumberOfWriteObjectPerTransaction(int maxNumberOfWriteObjectPerTransaction) {
        OdbConfiguration.maxNumberOfWriteObjectPerTransaction = maxNumberOfWriteObjectPerTransaction;
    }

    public static long getMaxNumberOfObjectInCache() {
        return maxNumberOfObjectInCache;
    }

    public static void setMaxNumberOfObjectInCache(long maxNumberOfObjectInCache) {
        OdbConfiguration.maxNumberOfObjectInCache = maxNumberOfObjectInCache;
    }

    public static int getNumberOfRetryToOpenFile() {
        return numberOfRetryToOpenFile;
    }

    public static void setNumberOfRetryToOpenFile(int numberOfRetryToOpenFile) {
        OdbConfiguration.numberOfRetryToOpenFile = numberOfRetryToOpenFile;
    }

    public static long getRetryTimeout() {
        return retryTimeout;
    }

    public static void setRetryTimeout(long retryTimeout) {
        OdbConfiguration.retryTimeout = retryTimeout;
    }

    public static boolean retryIfFileIsLocked() {
        return retryIfFileIsLocked;
    }

    public static void setRetryIfFileIsLocked(boolean retryIfFileIsLocked) {
        OdbConfiguration.retryIfFileIsLocked = retryIfFileIsLocked;
    }

    public static long getDefaultFileCreationTime() {
        return defaultFileCreationTime;
    }

    public static void setDefaultFileCreationTime(long defaultFileCreationTime) {
        OdbConfiguration.defaultFileCreationTime = defaultFileCreationTime;
    }

    public static boolean isMultiThread() {
        return retryIfFileIsLocked;
    }

    public static void useMultiThread(boolean yes) {
        OdbConfiguration.useMultiThread(yes, numberOfRetryToOpenFile);
    }

    public static void useMultiThread(boolean yes, int numberOfThreads) {
        OdbConfiguration.setRetryIfFileIsLocked(yes);
        if (yes) {
            OdbConfiguration.setNumberOfRetryToOpenFile(numberOfThreads * 10);
            OdbConfiguration.setRetryTimeout(50L);
        }
    }

    public static boolean throwExceptionWhenInconsistencyFound() {
        return throwExceptionWhenInconsistencyFound;
    }

    public static void setThrowExceptionWhenInconsistencyFound(boolean throwExceptionWhenInconsistencyFound) {
        OdbConfiguration.throwExceptionWhenInconsistencyFound = throwExceptionWhenInconsistencyFound;
    }

    public static boolean automaticallyIncreaseCacheSize() {
        return automaticallyIncreaseCacheSize;
    }

    public static void setAutomaticallyIncreaseCacheSize(boolean automaticallyIncreaseCache) {
        automaticallyIncreaseCacheSize = automaticallyIncreaseCache;
    }

    public static int getIdBlockSize() {
        return idBlockSize;
    }

    public static void setIdBlockSize(int idBlockSize) {
        OdbConfiguration.idBlockSize = idBlockSize;
    }

    public static int getNB_IDS_PER_BLOCK() {
        return 1000;
    }

    public static int getID_BLOCK_REPETITION_SIZE() {
        return 18;
    }

    public static boolean inPlaceUpdate() {
        return inPlaceUpdate;
    }

    public static int getStringSpaceReserveFactor() {
        return stringSpaceReserveFactor;
    }

    public static void setStringSpaceReserveFactor(int stringSpaceReserveFactor) {
        OdbConfiguration.stringSpaceReserveFactor = stringSpaceReserveFactor;
    }

    public static int getDebugLevel() {
        return debugLevel;
    }

    public static void setDebugLevel(int debugLevel) {
        OdbConfiguration.debugLevel = debugLevel;
    }

    public static int getDefaultBufferSizeForTransaction() {
        return defaultBufferSizeForTransaction;
    }

    public static void setDefaultBufferSizeForTransaction(int defaultBufferSizeForTransaction) {
        OdbConfiguration.defaultBufferSizeForTransaction = defaultBufferSizeForTransaction;
    }

    public static int getNbBuffers() {
        return nbBuffers;
    }

    public static void setNbBuffers(int nbBuffers) {
        OdbConfiguration.nbBuffers = nbBuffers;
    }

    public static boolean useMultiBuffer() {
        return useMultiBuffer;
    }

    public static void setUseMultiBuffer(boolean useMultiBuffer) {
        OdbConfiguration.useMultiBuffer = useMultiBuffer;
    }

    public static boolean checkModelCompatibility() {
        return checkModelCompatibility;
    }

    public static void setCheckModelCompatibility(boolean checkModelCompatibility) {
        OdbConfiguration.checkModelCompatibility = checkModelCompatibility;
    }

    public static boolean automaticCloseFileOnExit() {
        return automaticCloseFileOnExit;
    }

    public static void setAutomaticCloseFileOnExit(boolean automaticFileClose) {
        automaticCloseFileOnExit = automaticFileClose;
    }

    public static boolean isLogAll() {
        return logAll;
    }

    public static void setLogAll(boolean logAll) {
        OdbConfiguration.logAll = logAll;
    }

    public static boolean logServerConnections() {
        return logServerConnections;
    }

    public static void setLogServerConnections(boolean logServerConnections) {
        OdbConfiguration.logServerConnections = logServerConnections;
    }

    public static int getDefaultIndexBTreeDegree() {
        return defaultIndexBTreeDegree;
    }

    public static void setDefaultIndexBTreeDegree(int defaultIndexBTreeSize) {
        defaultIndexBTreeDegree = defaultIndexBTreeSize;
    }

    public static boolean useLazyCache() {
        return useLazyCache;
    }

    public static void setUseLazyCache(boolean useLazyCache) {
        OdbConfiguration.useLazyCache = useLazyCache;
    }

    public static IQueryExecutorCallback getQueryExecutorCallback() {
        return queryExecutorCallback;
    }

    public static void setQueryExecutorCallback(IQueryExecutorCallback queryExecutorCallback) {
        OdbConfiguration.queryExecutorCallback = queryExecutorCallback;
    }

    public static boolean useCache() {
        return useCache;
    }

    public static void setUseCache(boolean useCache) {
        OdbConfiguration.useCache = useCache;
    }

    public static boolean isMonitoringMemory() {
        return monitorMemory;
    }

    public static void monitorMemory(boolean yes) {
        monitorMemory = yes;
    }

    public static boolean displayWarnings() {
        return displayWarnings;
    }

    public static void setDisplayWarnings(boolean yesOrNo) {
        displayWarnings = yesOrNo;
    }

    public static boolean saveHistory() {
        return saveHistory;
    }

    public static void setSaveHistory(boolean saveTheHistory) {
        saveHistory = saveTheHistory;
    }

    public static int getScaleForAverageDivision() {
        return scaleForAverageDivision;
    }

    public static void setScaleForAverageDivision(int scaleForAverageDivision) {
        OdbConfiguration.scaleForAverageDivision = scaleForAverageDivision;
    }

    public static int getRoundTypeForAverageDivision() {
        return roundTypeForAverageDivision;
    }

    public static void setRoundTypeForAverageDivision(int roundTypeForAverageDivision) {
        OdbConfiguration.roundTypeForAverageDivision = roundTypeForAverageDivision;
    }

    public static boolean enableEmptyConstructorCreation() {
        return enableEmptyConstructorCreation;
    }

    public static void setEnableEmptyConstructorCreation(boolean enableEmptyConstructorCreation) {
        OdbConfiguration.enableEmptyConstructorCreation = enableEmptyConstructorCreation;
    }

    public static Class getIOClass() {
        return ioClass;
    }

    public static void setIOClass(Class IOClass, String password) {
        ioClass = IOClass;
        encryptionPassword = password;
    }

    public static String getEncryptionPassword() {
        return encryptionPassword;
    }

    public static ICoreProvider getCoreProvider() {
        if (!coreProviderInit) {
            coreProviderInit = true;
            try {
                coreProvider.init2();
            }
            catch (Exception e) {
                throw new ODBRuntimeException(NeoDatisError.ERROR_IN_CORE_PROVIDER_INITIALIZATION.addParameter("Core Provider"), (Throwable)e);
            }
        }
        return coreProvider;
    }

    public static void setCoreProvider(ICoreProvider coreProvider) {
        OdbConfiguration.coreProvider = coreProvider;
    }

    public static String getDatabaseCharacterEncoding() {
        return databaseCharacterEncoding;
    }

    public static void setDatabaseCharacterEncoding(String dbCharacterEncoding) throws UnsupportedEncodingException {
        if (dbCharacterEncoding != null) {
            new DefaultByteArrayConverter().testEncoding(dbCharacterEncoding);
            databaseCharacterEncoding = dbCharacterEncoding;
        } else {
            databaseCharacterEncoding = "no-encoding";
        }
    }

    public static void setLatinDatabaseCharacterEncoding() throws UnsupportedEncodingException {
        databaseCharacterEncoding = defaultDatabaseCharacterEncoding;
    }

    public static boolean hasEncoding() {
        return databaseCharacterEncoding != null && !databaseCharacterEncoding.equals("no-encoding");
    }

    public static ClassLoader getClassLoader() {
        return classLoader;
    }

    public static void setClassLoader(ClassLoader classLoader) {
        OdbConfiguration.classLoader = classLoader;
        OdbConfiguration.getCoreProvider().getClassIntrospector().reset();
        OdbConfiguration.getCoreProvider().getClassPool().reset();
    }

    public static boolean checkRuntimeVersion() {
        return checkRuntimeVersion;
    }

    public static void setCheckRuntimeVersion(boolean checkJavaRuntimeVersion) {
        checkRuntimeVersion = checkJavaRuntimeVersion;
    }

    public static Class getMessageStreamerClass() {
        return messageStreamerClass;
    }

    public static void setMessageStreamerClass(Class messageStreamerClass) {
        OdbConfiguration.messageStreamerClass = messageStreamerClass;
    }

    public static boolean logServerStartupAndShutdown() {
        return logServerStartupAndShutdown;
    }

    public static void setLogServerStartupAndShutdown(boolean logServerStartup) {
        logServerStartupAndShutdown = logServerStartup;
    }

    public static boolean useIndex() {
        return useIndex;
    }

    public static void setUseIndex(boolean useIndex) {
        OdbConfiguration.useIndex = useIndex;
    }

    public static boolean isDebugEnabled() {
        return debugEnabled;
    }

    public static void setDebugEnabled(boolean debugEnabled) {
        OdbConfiguration.debugEnabled = debugEnabled;
    }

    public static boolean shareSameVmConnectionMultiThread() {
        return shareSameVmConnectionMultiThread;
    }

    public static void setShareSameVmConnectionMultiThread(boolean shareSameVmConnectionMultiThread) {
        OdbConfiguration.shareSameVmConnectionMultiThread = shareSameVmConnectionMultiThread;
    }

    public static void lockObjectsOnSelect(boolean yesNo) {
        lockObjectsOnSelect = yesNo;
    }

    public static boolean lockObjectsOnSelect() {
        return lockObjectsOnSelect;
    }

    static {
        databaseCharacterEncoding = defaultDatabaseCharacterEncoding = "ISO8859-1";
        throwExceptionWhenInconsistencyFound = true;
        idBlockSize = 18034;
        inPlaceUpdate = false;
        stringSpaceReserveFactor = 1;
        checkModelCompatibility = true;
        monitorMemory = false;
        enableEmptyConstructorCreation = true;
        retryIfFileIsLocked = true;
        numberOfRetryToOpenFile = 5;
        retryTimeout = 100L;
        defaultFileCreationTime = 500L;
        automaticallyIncreaseCacheSize = false;
        useCache = true;
        logServerStartupAndShutdown = true;
        logServerConnections = false;
        defaultIndexBTreeDegree = 20;
        useLazyCache = false;
        displayWarnings = true;
        queryExecutorCallback = null;
        scaleForAverageDivision = 2;
        roundTypeForAverageDivision = 5;
        ioClass = OdbFileIO.class;
        coreProvider = new DefaultCoreProvider();
        checkRuntimeVersion = true;
        reconnectObjectsToSession = false;
        classLoader = NeoDatisClassLoader.getCurrent();
        messageStreamerClass = DefaultMessageStreamer.class;
        useIndex = true;
        shareSameVmConnectionMultiThread = true;
        lockObjectsOnSelect = false;
    }
}

