/*
 * Decompiled with CFR 0.152.
 */
package org.nfunk.jeptesting;

import java.io.BufferedReader;
import java.io.FileReader;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.nfunk.jep.JEP;
import org.nfunk.jep.type.Complex;

public class JEPTest
extends TestCase {
    JEP myParser;
    int lineCount;

    public JEPTest(String name) {
        super(name);
    }

    public void setUp() {
        this.myParser = new JEP();
        this.myParser.setImplicitMul(true);
        this.myParser.addStandardFunctions();
        this.myParser.addStandardConstants();
        this.myParser.addComplex();
        this.myParser.setTraverse(false);
        this.lineCount = 0;
    }

    public void runTest() {
        String fileName = "JEPTestExpressions.txt";
        this.testWithFile(fileName);
        this.testGetValue();
        this.testGetComplexValue();
        this.testOpSetBug();
    }

    public static void main(String[] args) {
        String fileName;
        if (args != null && args.length > 0) {
            fileName = args[0];
        } else {
            fileName = "JEPTestExpressions.txt";
            JEPTest.println("Using default input file: " + fileName);
            JEPTest.println("Start with \"java org.nfunk.jepexamples.JEPTest <filename>\" to load a different input file.");
        }
        JEPTest jt = new JEPTest("JEP Test");
        jt.setUp();
        jt.testWithFile(fileName);
    }

    public void testWithFile(String fileName) {
        BufferedReader reader;
        boolean hasError = false;
        try {
            reader = new BufferedReader(new FileReader(fileName));
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)false);
            JEPTest.println("File \"" + fileName + "\" not found");
            return;
        }
        this.lineCount = 0;
        JEPTest.println("Evaluating and comparing expressions...");
        while (true) {
            Object v2;
            Object v1;
            try {
                v1 = this.parseNextLine(reader);
                v2 = this.parseNextLine(reader);
            }
            catch (Exception e) {
                JEPTest.println(e.getMessage());
                hasError = true;
                break;
            }
            if (v1 == null || v2 == null) {
                JEPTest.println("Reached end of file.");
                break;
            }
            try {
                if (this.equal(v1, v2)) continue;
                hasError = true;
                JEPTest.print("Line: " + this.lineCount + ": ");
                JEPTest.println(String.valueOf(v1.toString()) + " != " + v2.toString());
            }
            catch (Exception e) {
                hasError = true;
                JEPTest.println(e.getMessage());
            }
        }
        JEPTest.print("\n" + this.lineCount + " lines processed. ");
        if (hasError) {
            JEPTest.print("Errors were found.\n\n");
        } else {
            JEPTest.print("No errors were found.\n\n");
        }
    }

    private Object parseNextLine(BufferedReader reader) throws Exception {
        String line;
        do {
            if ((line = reader.readLine()) == null) {
                return null;
            }
            ++this.lineCount;
        } while (line.length() == 0 || line.trim().charAt(0) == '#');
        this.myParser.parseExpression(line);
        if (this.myParser.hasError()) {
            String errorStr = this.myParser.getErrorInfo();
            throw new Exception("Error while parsing line " + this.lineCount + ": " + errorStr);
        }
        Object value = this.myParser.getValueAsObject();
        if (value == null || this.myParser.hasError()) {
            String errorStr = this.myParser.getErrorInfo();
            throw new Exception("Error while evaluating line " + this.lineCount + ": " + errorStr);
        }
        return value;
    }

    private boolean equal(Object param1, Object param2) throws Exception {
        double tolerance = 1.0E-15;
        if (param1 instanceof Complex && param2 instanceof Complex) {
            return ((Complex)param1).equals((Complex)param2, tolerance);
        }
        if (param1 instanceof Complex && param2 instanceof Number) {
            return ((Complex)param1).equals(new Complex((Number)param2), tolerance);
        }
        if (param2 instanceof Complex && param1 instanceof Number) {
            return ((Complex)param2).equals(new Complex((Number)param1), tolerance);
        }
        if (param1 instanceof Number && param2 instanceof Number) {
            return Math.abs(((Number)param1).doubleValue() - ((Number)param2).doubleValue()) < tolerance;
        }
        return param1.equals(param2);
    }

    public void testGetValue() {
        this.myParser.parseExpression("2.1345");
        Assert.assertEquals((double)this.myParser.getValue(), (double)2.1345, (double)0.0);
        this.myParser.parseExpression("i");
        Assert.assertTrue((boolean)Double.isNaN(this.myParser.getValue()));
        this.myParser.parseExpression("\"asdf\"");
        Assert.assertTrue((boolean)Double.isNaN(this.myParser.getValue()));
    }

    public void testGetComplexValue() {
        this.myParser.parseExpression("2.1345");
        Assert.assertTrue((boolean)new Complex(2.1345, 0.0).equals(this.myParser.getComplexValue(), 0.0));
        this.myParser.parseExpression("i");
        Complex z = this.myParser.getComplexValue();
        Assert.assertTrue((z != null ? 1 : 0) != 0);
        Assert.assertTrue((z.re() == 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((z.im() == 1.0 ? 1 : 0) != 0);
        this.myParser.parseExpression("\"asdf\"");
        Assert.assertTrue((boolean)Double.isNaN(this.myParser.getValue()));
    }

    public void testOpSetBug() {
        JEP j = new JEP(false, true, true, null);
        Assert.assertNotNull((Object)j.getOperatorSet());
    }

    private static void print(String str) {
        System.out.print(str);
    }

    private static void println(String str) {
        System.out.println(str);
    }
}

