/*
 * Decompiled with CFR 0.152.
 */
package org.nfunk.jep.function;

import java.util.Stack;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.PostfixMathCommand;

public class Binomial
extends PostfixMathCommand {
    static final int initN = 20;
    static int[][] coeffs = new int[21][];

    static void expand(int N) {
        int oldN = coeffs.length - 1;
        if (N <= oldN) {
            return;
        }
        int[][] newCoeffs = new int[N + 1][];
        int i = 0;
        while (i <= oldN) {
            newCoeffs[i] = coeffs[i];
            ++i;
        }
        int n = oldN + 1;
        while (n <= N) {
            newCoeffs[n] = new int[n + 1];
            newCoeffs[n][0] = 1;
            newCoeffs[n][n] = 1;
            int j = 1;
            while (j < n) {
                newCoeffs[n][j] = newCoeffs[n - 1][j - 1] + newCoeffs[n - 1][j];
                ++j;
            }
            ++n;
        }
        coeffs = newCoeffs;
    }

    public Binomial() {
        Binomial.coeffs[0] = new int[1];
        Binomial.coeffs[0][0] = 1;
        Binomial.coeffs[1] = new int[2];
        Binomial.coeffs[1][0] = 1;
        Binomial.coeffs[1][1] = 1;
        int n = 2;
        while (n <= 20) {
            Binomial.coeffs[n] = new int[n + 1];
            Binomial.coeffs[n][0] = 1;
            Binomial.coeffs[n][n] = 1;
            int j = 1;
            while (j < n) {
                Binomial.coeffs[n][j] = coeffs[n - 1][j - 1] + coeffs[n - 1][j];
                ++j;
            }
            ++n;
        }
        this.numberOfParameters = 2;
    }

    public void run(Stack s) throws ParseException {
        Object iObj = s.pop();
        Object nObj = s.pop();
        if (!(iObj instanceof Number) || !(nObj instanceof Number)) {
            throw new ParseException("Binomial: both arguments must be integers. They are " + nObj + "(" + nObj.getClass().getName() + ") and " + iObj + "(" + nObj.getClass().getName() + ")");
        }
        int iInt = ((Number)iObj).intValue();
        int nInt = ((Number)nObj).intValue();
        if (nInt < 0 || iInt < 0 || iInt > nInt) {
            throw new ParseException("Binomial: illegal values for arguments 0<i<n. They are " + nObj + " and " + iObj);
        }
        Binomial.expand(nInt);
        int res = coeffs[nInt][iInt];
        s.push(new Integer(res));
    }

    public static int binom(int n, int i) throws ArrayIndexOutOfBoundsException {
        Binomial.expand(n);
        return coeffs[n][i];
    }
}

