/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djepJUnit;

import java.text.NumberFormat;
import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.lsmp.djep.xjep.BaseFormat;
import org.lsmp.djep.xjep.MacroFunction;
import org.lsmp.djep.xjep.XJep;
import org.lsmp.djep.xjep.XOperator;
import org.lsmp.djepJUnit.JepTest;
import org.nfunk.jep.Node;
import org.nfunk.jep.OperatorSet;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.Variable;
import org.nfunk.jep.type.Complex;

public class XJepTest
extends JepTest {
    static /* synthetic */ Class class$0;

    public XJepTest(String name) {
        super(name);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.lsmp.djepJUnit.XJepTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public static void main(String[] args) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.lsmp.djepJUnit.XJepTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestSuite suite = new TestSuite((Class)clazz);
        suite.run(new TestResult());
    }

    protected void setUp() {
        this.j = new XJep();
        this.j.addStandardConstants();
        this.j.addStandardFunctions();
        this.j.addComplex();
        this.j.setAllowAssignment(true);
        this.j.setAllowUndeclared(true);
        this.j.setImplicitMul(true);
    }

    public String parsePreprocSimp(String expr) throws ParseException {
        XJep xj = (XJep)this.j;
        Node node = xj.parse(expr);
        Node matEqn = xj.preprocess(node);
        Node simp = xj.simplify(matEqn);
        String res = xj.toString(simp);
        return res;
    }

    public void simplifyTestString(String expr, String expected) throws ParseException {
        XJep xj = (XJep)this.j;
        Node node = xj.parse(expr);
        Node processed = xj.preprocess(node);
        Node simp = xj.simplify(processed);
        String res = xj.toString(simp);
        if (!expected.equals(res)) {
            System.out.println("Error: Value of \"" + expr + "\" is \"" + res + "\" should be \"" + expected + "\"");
        }
        XJepTest.assertEquals((String)("<" + expr + ">"), (Object)expected, (Object)res);
        System.out.println("Success: Value of \"" + expr + "\" is \"" + res + "\"");
    }

    public void simplifyTest(String expr, String expected) throws ParseException {
        XJep xj = (XJep)this.j;
        Node node2 = xj.parse(expected);
        Node processed2 = xj.preprocess(node2);
        Node simp2 = xj.simplify(processed2);
        String res2 = xj.toString(simp2);
        this.simplifyTestString(expr, res2);
    }

    public Node parseProcSimpEval(String expr, Object expected) throws ParseException, Exception {
        XJep xj = (XJep)this.j;
        Node node = xj.parse(expr);
        Node processed = xj.preprocess(node);
        Node simp = xj.simplify(processed);
        Object res = xj.evaluate(simp);
        this.myAssertEquals(expr, expected, res);
        return simp;
    }

    public void testLogical() throws Exception {
        super.testLogical();
        OperatorSet opSet = this.j.getOperatorSet();
        if (!((XOperator)opSet.getMultiply()).isDistributiveOver(opSet.getAdd())) {
            XJepTest.fail((String)"* should be distributive over +");
        }
        if (((XOperator)opSet.getMultiply()).isDistributiveOver(opSet.getDivide())) {
            XJepTest.fail((String)"* should not be distributive over /");
        }
        if (((XOperator)opSet.getMultiply()).getPrecedence() > ((XOperator)opSet.getAdd()).getPrecedence()) {
            XJepTest.fail((String)"* should have a lower precedence than +");
        }
    }

    public void testPrint() throws ParseException {
        this.simplifyTestString("(a+b)+c", "a+b+c");
        this.simplifyTestString("(a-b)+c", "a-b+c");
        this.simplifyTestString("(a+b)-c", "a+b-c");
        this.simplifyTestString("(a-b)-c", "a-b-c");
        this.simplifyTestString("a+(b+c)", "a+b+c");
        this.simplifyTestString("a-(b+c)", "a-(b+c)");
        this.simplifyTestString("a+(b-c)", "a+b-c");
        this.simplifyTestString("a-(b-c)", "a-(b-c)");
        this.simplifyTestString("(a*b)*c", "a*b*c");
        this.simplifyTestString("(a/b)*c", "(a/b)*c");
        this.simplifyTestString("(a*b)/c", "a*b/c");
        this.simplifyTestString("(a/b)/c", "(a/b)/c");
        this.simplifyTestString("a*(b*c)", "a*b*c");
        this.simplifyTestString("a/(b*c)", "a/(b*c)");
        this.simplifyTestString("a*(b/c)", "a*b/c");
        this.simplifyTestString("a/(b/c)", "a/(b/c)");
        this.simplifyTestString("a=(b=c)", "a=b=c");
        this.simplifyTestString("(a*b)+c", "a*b+c");
        this.simplifyTestString("(a+b)*c", "(a+b)*c");
        this.simplifyTestString("a*(b+c)", "a*(b+c)");
        this.simplifyTestString("a+(b*c)", "a+b*c");
        this.simplifyTestString("(a||b)||c", "a||b||c");
        this.simplifyTestString("(a&&b)||c", "a&&b||c");
        this.simplifyTestString("(a||b)&&c", "(a||b)&&c");
        this.simplifyTestString("(a&&b)&&c", "a&&b&&c");
        this.simplifyTestString("a||(b||c)", "a||b||c");
        this.simplifyTestString("a&&(b||c)", "a&&(b||c)");
        this.simplifyTestString("a||(b&&c)", "a||b&&c");
        this.simplifyTestString("a&&(b&&c)", "a&&b&&c");
    }

    public void testSimp() throws ParseException {
        this.simplifyTest("2+3", "5");
        this.simplifyTest("2*3", "6");
        this.simplifyTest("2^3", "8");
        this.simplifyTest("3/2", "1.5");
        this.simplifyTest("2*3+4", "10");
        this.simplifyTest("2*(3+4)", "14");
        this.simplifyTest("0+x", "x");
        this.simplifyTest("x+0", "x");
        this.simplifyTest("0-x", "0-x");
        this.simplifyTest("x-0", "x");
        this.simplifyTest("0*x", "0");
        this.simplifyTest("x*0", "0");
        this.simplifyTest("1*x", "x");
        this.simplifyTest("x*1", "x");
        this.simplifyTest("-1*x", "-x");
        this.simplifyTest("x*-1", "-x");
        this.simplifyTest("-(-x)", "x");
        this.simplifyTest("-(-(-x))", "-x");
        this.simplifyTest("(-1)*(-1)*x", "x");
        this.simplifyTest("(-1)*(-1)*(-1)*x", "-x");
        this.simplifyTest("0/x", "0");
        this.simplifyTest("x/0", "1/0");
        this.simplifyTest("x^0", "1");
        this.simplifyTest("x^1", "x");
        this.simplifyTest("0^x", "0");
        this.simplifyTest("1^x", "1");
        this.simplifyTest("(2+3)+x", "5+x");
        this.simplifyTest("(2+x)+3", "5+x");
        this.simplifyTest("(x+2)+3", "5+x");
        this.simplifyTest("x+(2+3)", "5+x");
        this.simplifyTest("2+(x+3)", "5+x");
        this.simplifyTest("2+(3+x)", "5+x");
        this.simplifyTest("(2+3)-x", "5-x");
        this.simplifyTest("(2+x)-3", "x-1");
        this.simplifyTest("(x+2)-3", "x-1");
        this.simplifyTest("(2-3)+x", "-1+x");
        this.simplifyTest("(2-x)+3", "5-x");
        this.simplifyTest("(x-2)+3", "1+x");
        this.simplifyTest("x-(2+3)", "x-5");
        this.simplifyTest("2-(x+3)", "-1-x");
        this.simplifyTest("2-(3+x)", "-1-x");
        this.simplifyTest("x+(2-3)", "x-1");
        this.simplifyTest("2+(x-3)", "-1+x");
        this.simplifyTest("2+(3-x)", "5-x");
        this.simplifyTest("x-(2-3)", "1+x");
        this.simplifyTest("2-(x-3)", "5-x");
        this.simplifyTest("2-(3-x)", "-1+x");
        this.simplifyTest("(2-3)-x", "-1-x");
        this.simplifyTest("(2-x)-3", "-1-x");
        this.simplifyTest("(x-2)-3", "x-5");
        this.simplifyTest("(2*3)*x", "6*x");
        this.simplifyTest("(2*x)*3", "6*x");
        this.simplifyTest("(x*2)*3", "6*x");
        this.simplifyTest("x*(2*3)", "6*x");
        this.simplifyTest("2*(x*3)", "6*x");
        this.simplifyTest("2*(3*x)", "6*x");
        this.simplifyTest("(2*3)/x", "6/x");
        this.simplifyTest("(3*x)/2", "1.5*x");
        this.simplifyTest("(x*3)/2", "1.5*x");
        this.simplifyTest("(3/2)*x", "1.5*x");
        this.simplifyTest("(3/x)*2", "6/x");
        this.simplifyTest("(x/2)*3", "1.5*x");
        this.simplifyTest("x/(2*3)", "x/6");
        this.simplifyTest("3/(x*2)", "1.5/x");
        this.simplifyTest("3/(2*x)", "1.5/x");
        this.simplifyTest("x*(3/2)", "1.5*x");
        this.simplifyTest("3*(x/2)", "1.5*x");
        this.simplifyTest("3*(2/x)", "6/x");
        this.simplifyTest("x/(3/2)", "x/1.5");
        this.simplifyTest("2/(x/3)", "6/x");
        this.simplifyTest("3/(2/x)", "1.5*x");
        this.simplifyTest("(3/2)/x", "1.5/x");
        this.simplifyTest("(3/x)/2", "1.5/x");
        this.simplifyTest("(x/3)/2", "x/6");
        this.simplifyTest("x*(3+2)", "5*x");
        this.simplifyTest("3*(x+2)", "6+3*x");
        this.simplifyTest("3*(2+x)", "6+3*x");
        this.simplifyTest("(3+2)*x", "5*x");
        this.simplifyTest("(3+x)*2", "6+2*x");
        this.simplifyTest("(x+3)*2", "6+x*2");
        this.simplifyTest("x*(3-2)", "x");
        this.simplifyTest("3*(x-2)", "-6+3*x");
        this.simplifyTest("3*(2-x)", "6-3*x");
        this.simplifyTest("(3-2)*x", "x");
        this.simplifyTest("(3-x)*2", "6-2*x");
        this.simplifyTest("(x-3)*2", "-6+2*x");
        this.simplifyTest("3+(x/4)", "3+x/4");
        this.simplifyTest("2*(x/4)", "0.5*x");
        this.simplifyTest("(2*(3+(x/4)))", "6+0.5*x");
        this.simplifyTest("1+(2*(3+(x/4)))", "7+0.5*x");
        this.simplifyTest("((3+(x/4))*2)+1", "7+0.5*x");
        this.simplifyTest("(x/2)*3", "x*1.5");
    }

    public void testMacroFun() throws Exception {
        this.j.addFunction("zap", new MacroFunction("zap", 1, "x*(x-1)/2", (XJep)this.j));
        this.valueTest("zap(10)", 45.0);
        this.j.addFunction("zap2", new MacroFunction("zap", 4, "x1+x2+x3+x4", (XJep)this.j));
        this.valueTest("zap2(5,5,3,6)", 19.0);
    }

    public void testVariableReuse() throws Exception {
        XJep xj = (XJep)this.j;
        System.out.println("\nTesting variable reuse");
        this.parseProcSimpEval("x=3", new Double(3.0));
        Node node13 = this.parseProcSimpEval("y=x^2", new Double(9.0));
        Node node15 = this.parseProcSimpEval("z=y+x", new Double(12.0));
        this.j.setVarValue("x", new Double(4.0));
        System.out.println("j.setVarValue(\"x\",new Double(4));");
        System.out.println("j.getVarValue(y): " + this.j.getVarValue("y"));
        this.myAssertEquals("eval y eqn", "16.0", this.j.evaluate(node13).toString());
        System.out.println("j.getVarValue(y): " + this.j.getVarValue("y"));
        this.myAssertEquals("eval z eqn", "20.0", this.j.evaluate(node15).toString());
        this.j.setVarValue("x", new Double(5.0));
        System.out.println("j.setVarValue(\"x\",new Double(5));");
        this.myAssertEquals("j.findVarValue(y)", "25.0", xj.calcVarValue("y").toString());
        this.myAssertEquals("j.findVarValue(z)", "30.0", xj.calcVarValue("z").toString());
        this.j.getSymbolTable().clearValues();
        this.j.setVarValue("x", new Double(6.0));
        System.out.println("j.setVarValue(\"x\",new Double(6));");
        this.myAssertEquals("j.findVarValue(z)", "42.0", xj.calcVarValue("z").toString());
        this.myAssertEquals("j.findVarValue(y)", "36.0", xj.calcVarValue("y").toString());
        this.parseProcSimpEval("x=7", new Double(7.0));
        this.myAssertEquals("eval y eqn", "49.0", this.j.evaluate(node13).toString());
        this.myAssertEquals("eval z eqn", "56.0", this.j.evaluate(node15).toString());
    }

    public void testReentrant() throws ParseException, Exception {
        XJep xj = (XJep)this.j;
        xj.restartParser("x=1; // semi-colon; in comment\n y=2; z=x+y;");
        Node node = xj.continueParsing();
        this.myAssertEquals("x=1; ...", "1.0", this.calcValue(node).toString());
        node = xj.continueParsing();
        this.myAssertEquals("..., y=2; ...", "2.0", this.calcValue(node).toString());
        node = xj.continueParsing();
        this.myAssertEquals("..., z=x+y;", "3.0", this.calcValue(node).toString());
        node = xj.continueParsing();
        XJepTest.assertNull((String)"empty string ", (Object)node);
    }

    public void testFormat() throws ParseException {
        XJep xj = (XJep)this.j;
        NumberFormat format = NumberFormat.getInstance();
        xj.getPrintVisitor().setNumberFormat(format);
        format.setMaximumFractionDigits(3);
        format.setMinimumFractionDigits(0);
        String s1 = "[10,0,0.1,0.11,0.111,0.1111]";
        String r1 = xj.toString(this.j.parse(s1));
        String s2 = "[0.9,0.99,0.999,0.9999]";
        String r2 = xj.toString(this.j.parse(s2));
        this.myAssertEquals(s1, r1, "[10,0,0.1,0.11,0.111,0.111]");
        this.myAssertEquals(s2, r2, "[0.9,0.99,0.999,1]");
        xj.println(this.j.parse("[0,1,i,1+i]"));
        xj.getPrintVisitor().setMode(2, true);
        xj.println(xj.simplify(this.j.parse("(2+i)+(1+i)")));
        Complex c = (Complex)this.calcValue("(2+i)+(1+i)");
        System.out.println(c.toString(format, true));
    }

    public void testVarInEqn() throws Exception {
        XJep xj = (XJep)this.j;
        Node n1 = this.j.parse("a+b+c+d");
        Vector v = xj.getVarsInEquation(n1, new Vector());
        XJepTest.assertTrue((String)"Does not contain a", (boolean)v.contains(this.j.getSymbolTable().getVar("a")));
        XJepTest.assertTrue((String)"Does not contain b", (boolean)v.contains(this.j.getSymbolTable().getVar("b")));
        XJepTest.assertTrue((String)"Does not contain c", (boolean)v.contains(this.j.getSymbolTable().getVar("c")));
        XJepTest.assertTrue((String)"Does not contain d", (boolean)v.contains(this.j.getSymbolTable().getVar("d")));
        xj.preprocess(this.j.parse("x=a+b t"));
        xj.preprocess(this.j.parse("y=c+d t"));
        xj.preprocess(this.j.parse("f=x*y"));
        xj.preprocess(this.j.parse("g=x+y"));
        Node n2 = xj.preprocess(this.j.parse("f+g"));
        Vector v2 = xj.recursiveGetVarsInEquation(n2, new Vector());
        Vector<Variable> v3 = new Vector<Variable>();
        v3.add(this.j.getVar("a"));
        v3.add(this.j.getVar("b"));
        v3.add(this.j.getVar("t"));
        v3.add(this.j.getVar("x"));
        v3.add(this.j.getVar("c"));
        v3.add(this.j.getVar("d"));
        v3.add(this.j.getVar("y"));
        v3.add(this.j.getVar("f"));
        v3.add(this.j.getVar("g"));
        System.out.println(v2.toString());
        XJepTest.assertEquals((String)"Bad element seq", v3, (Object)v2);
    }

    public void testUndecVar() throws ParseException {
        this.j.setAllowUndeclared(true);
        Node node1 = ((XJep)this.j).parse("zap * biff * gosh");
        ((XJep)this.j).preprocess(node1);
    }

    public void testSum() throws Exception {
        this.valueTest("Sum(x,x,1,10)", 55.0);
        this.valueTest("Sum(x^2,x,1,5)", 55.0);
        this.valueTest("Product(x,x,1,5)", 120.0);
        this.valueTest("Min(x^2,x,1,5)", 1.0);
        this.valueTest("Max(x^2,x,1,5)", 25.0);
        this.valueTest("MinArg(x^2,x,1,5)", 1.0);
        this.valueTest("MaxArg(x^2,x,1,5)", 5.0);
    }

    public void testHex() throws Exception {
        this.valueTest("toHex(0)", "0x0");
        this.valueTest("toHex(0,1)", "0x0.0");
        this.valueTest("toHex(0,2)", "0x0.00");
        this.valueTest("toHex(1)", "0x1");
        this.valueTest("toHex(1,1)", "0x1.0");
        this.valueTest("toHex(1,2)", "0x1.00");
        this.valueTest("toHex(-1)", "-0x1");
        this.valueTest("toHex(-1,1)", "-0x1.0");
        this.valueTest("toHex(-1,2)", "-0x1.00");
        this.valueTest("toHex(7)", "0x7");
        this.valueTest("toHex(7,1)", "0x7.0");
        this.valueTest("toHex(7,2)", "0x7.00");
        this.valueTest("toHex(-7)", "-0x7");
        this.valueTest("toHex(-7,1)", "-0x7.0");
        this.valueTest("toHex(-7,2)", "-0x7.00");
        this.valueTest("toHex(8)", "0x8");
        this.valueTest("toHex(8,1)", "0x8.0");
        this.valueTest("toHex(8,2)", "0x8.00");
        this.valueTest("toHex(-8)", "-0x8");
        this.valueTest("toHex(-8,1)", "-0x8.0");
        this.valueTest("toHex(-8,2)", "-0x8.00");
        this.valueTest("toHex(10)", "0xa");
        this.valueTest("toHex(10,1)", "0xa.0");
        this.valueTest("toHex(10,2)", "0xa.00");
        this.valueTest("toHex(-10)", "-0xa");
        this.valueTest("toHex(-10,1)", "-0xa.0");
        this.valueTest("toHex(-10,2)", "-0xa.00");
        this.valueTest("toHex(15)", "0xf");
        this.valueTest("toHex(15,1)", "0xf.0");
        this.valueTest("toHex(15,2)", "0xf.00");
        this.valueTest("toHex(-15)", "-0xf");
        this.valueTest("toHex(-15,1)", "-0xf.0");
        this.valueTest("toHex(-15,2)", "-0xf.00");
        this.valueTest("toHex(16)", "0x10");
        this.valueTest("toHex(16,1)", "0x10.0");
        this.valueTest("toHex(16,2)", "0x10.00");
        this.valueTest("toHex(-16)", "-0x10");
        this.valueTest("toHex(-16,1)", "-0x10.0");
        this.valueTest("toHex(-16,2)", "-0x10.00");
        this.valueTest("toHex(17)", "0x11");
        this.valueTest("toHex(17,1)", "0x11.0");
        this.valueTest("toHex(17,2)", "0x11.00");
        this.valueTest("toHex(-17)", "-0x11");
        this.valueTest("toHex(-17,1)", "-0x11.0");
        this.valueTest("toHex(-17,2)", "-0x11.00");
        this.valueTest("toHex(256)", "0x100");
        this.valueTest("toHex(256,1)", "0x100.0");
        this.valueTest("toHex(256,2)", "0x100.00");
        this.valueTest("toHex(-256)", "-0x100");
        this.valueTest("toHex(-256,1)", "-0x100.0");
        this.valueTest("toHex(-256,2)", "-0x100.00");
        this.valueTest("toHex(1/16)", "0x0");
        this.valueTest("toHex(1/16,1)", "0x0.1");
        this.valueTest("toHex(1/16,2)", "0x0.10");
        this.valueTest("toHex(-1/16)", "-0x0");
        this.valueTest("toHex(-1/16,1)", "-0x0.1");
        this.valueTest("toHex(-1/16,2)", "-0x0.10");
        this.valueTest("toHex(7/16)", "0x0");
        this.valueTest("toHex(7/16,1)", "0x0.7");
        this.valueTest("toHex(7/16,2)", "0x0.70");
        this.valueTest("toHex(-7/16)", "-0x0");
        this.valueTest("toHex(-7/16,1)", "-0x0.7");
        this.valueTest("toHex(-7/16,2)", "-0x0.70");
        this.valueTest("toHex(8/16)", "0x1");
        this.valueTest("toHex(8/16,1)", "0x0.8");
        this.valueTest("toHex(8/16,2)", "0x0.80");
        this.valueTest("toHex(-8/16)", "-0x1");
        this.valueTest("toHex(-8/16,1)", "-0x0.8");
        this.valueTest("toHex(-8/16,2)", "-0x0.80");
        this.valueTest("toHex(10/16)", "0x1");
        this.valueTest("toHex(10/16,1)", "0x0.a");
        this.valueTest("toHex(10/16,2)", "0x0.a0");
        this.valueTest("toHex(-10/16)", "-0x1");
        this.valueTest("toHex(-10/16,1)", "-0x0.a");
        this.valueTest("toHex(-10/16,2)", "-0x0.a0");
        this.valueTest("toHex(15/16)", "0x1");
        this.valueTest("toHex(15/16,1)", "0x0.f");
        this.valueTest("toHex(15/16,2)", "0x0.f0");
        this.valueTest("toHex(-15/16)", "-0x1");
        this.valueTest("toHex(-15/16,1)", "-0x0.f");
        this.valueTest("toHex(-15/16,2)", "-0x0.f0");
        this.valueTest("toHex(17/16)", "0x1");
        this.valueTest("toHex(17/16,1)", "0x1.1");
        this.valueTest("toHex(17/16,2)", "0x1.10");
        this.valueTest("toHex(-17/16)", "-0x1");
        this.valueTest("toHex(-17/16,1)", "-0x1.1");
        this.valueTest("toHex(-17/16,2)", "-0x1.10");
        this.valueTest("toHex(31/16)", "0x2");
        this.valueTest("toHex(31/16,1)", "0x1.f");
        this.valueTest("toHex(31/16,2)", "0x1.f0");
        this.valueTest("toHex(-31/16)", "-0x2");
        this.valueTest("toHex(-31/16,1)", "-0x1.f");
        this.valueTest("toHex(-31/16,2)", "-0x1.f0");
        this.valueTest("toHex(1/256)", "0x0");
        this.valueTest("toHex(1/256,1)", "0x0.0");
        this.valueTest("toHex(1/256,2)", "0x0.01");
        this.valueTest("toHex(-1/256)", "-0x0");
        this.valueTest("toHex(-1/256,1)", "-0x0.0");
        this.valueTest("toHex(-1/256,2)", "-0x0.01");
        this.valueTest("toHex(15/256)", "0x0");
        this.valueTest("toHex(15/256,1)", "0x0.1");
        this.valueTest("toHex(15/256,2)", "0x0.0f");
        this.valueTest("toHex(-15/256)", "-0x0");
        this.valueTest("toHex(-15/256,1)", "-0x0.1");
        this.valueTest("toHex(-15/256,2)", "-0x0.0f");
        this.valueTest("toHex(17/256)", "0x0");
        this.valueTest("toHex(17/256,1)", "0x0.1");
        this.valueTest("toHex(17/256,2)", "0x0.11");
        this.valueTest("toHex(-17/256)", "-0x0");
        this.valueTest("toHex(-17/256,1)", "-0x0.1");
        this.valueTest("toHex(-17/256,2)", "-0x0.11");
        this.valueTest("toHex(127/256)", "0x0");
        this.valueTest("toHex(127/256,1)", "0x0.8");
        this.valueTest("toHex(127/256,2)", "0x0.7f");
        this.valueTest("toHex(-127/256)", "-0x0");
        this.valueTest("toHex(-127/256,1)", "-0x0.8");
        this.valueTest("toHex(-127/256,2)", "-0x0.7f");
        this.valueTest("toHex(128/256)", "0x1");
        this.valueTest("toHex(128/256,1)", "0x0.8");
        this.valueTest("toHex(128/256,2)", "0x0.80");
        this.valueTest("toHex(-128/256)", "-0x1");
        this.valueTest("toHex(-128/256,1)", "-0x0.8");
        this.valueTest("toHex(-128/256,2)", "-0x0.80");
        this.valueTest("toHex(240/256)", "0x1");
        this.valueTest("toHex(240/256,1)", "0x0.f");
        this.valueTest("toHex(240/256,2)", "0x0.f0");
        this.valueTest("toHex(-240/256)", "-0x1");
        this.valueTest("toHex(-240/256,1)", "-0x0.f");
        this.valueTest("toHex(-240/256,2)", "-0x0.f0");
        this.valueTest("toHex(248/256)", "0x1");
        this.valueTest("toHex(248/256,1)", "0x1.0");
        this.valueTest("toHex(248/256,2)", "0x0.f8");
        this.valueTest("toHex(-248/256)", "-0x1");
        this.valueTest("toHex(-248/256,1)", "-0x1.0");
        this.valueTest("toHex(-248/256,2)", "-0x0.f8");
        this.valueTest("toHex(1/4096)", "0x0");
        this.valueTest("toHex(1/4096,1)", "0x0.0");
        this.valueTest("toHex(1/4096,2)", "0x0.00");
        this.valueTest("toHex(1/4096,3)", "0x0.001");
        this.valueTest("toHex(1/4096,4)", "0x0.0010");
        this.valueTest("toHex(1+1/4096)", "0x1");
        this.valueTest("toHex(1+1/4096,1)", "0x1.0");
        this.valueTest("toHex(1+1/4096,2)", "0x1.00");
        this.valueTest("toHex(1+1/4096,3)", "0x1.001");
        this.valueTest("toHex(1+1/4096,4)", "0x1.0010");
        XJep xj = (XJep)this.j;
        BaseFormat bf = new BaseFormat(16, "0x");
        bf.setMaximumFractionDigits(0);
        xj.getPrintVisitor().setNumberFormat(bf);
        String st = "10 x+15 x^2 - 16 x^3 + 32 x^4 - 256 x^5";
        Node n = xj.parse(st);
        String res = xj.toString(n);
        this.myAssertEquals(st, "0xa*x+0xf*x^0x2-0x10*x^0x3+0x20*x^0x4-0x100*x^0x5", res);
    }

    public void testDefine() throws Exception {
        XJep xj = (XJep)this.j;
    }

    public void testBad() throws Exception {
    }
}

