/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djepExamples;

import java.text.NumberFormat;
import java.util.Enumeration;
import org.lsmp.djep.xjep.PrintVisitor;
import org.lsmp.djep.xjep.XJep;
import org.lsmp.djep.xjep.XOperator;
import org.lsmp.djep.xjep.XVariable;
import org.lsmp.djepExamples.Console;
import org.nfunk.jep.Node;
import org.nfunk.jep.Operator;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.SymbolTable;

public class XJepConsole
extends Console {
    private static final long serialVersionUID = -3239922790774093668L;
    protected NumberFormat format = null;
    protected boolean verbose = false;

    public static void main(String[] args) {
        XJepConsole c = new XJepConsole();
        c.run(args);
    }

    public String getPrompt() {
        return "XJep > ";
    }

    public void initialise() {
        this.j = new XJep();
        this.j.addStandardConstants();
        this.j.addStandardFunctions();
        this.j.addComplex();
        this.j.setAllowUndeclared(true);
        this.j.setAllowAssignment(true);
        this.j.setImplicitMul(true);
    }

    public void printHelp() {
        super.printHelp();
        this.println("'setMaxLen 80'\tensures all lines and < 80 chars");
        this.println("'setDP 3'\tonly prints 3 decimal places");
        this.println("'setFullBrackets true'\tprints equations with full bracketing");
        this.println("'setComplexI true'\tprint complex numbers in form x+iy");
        this.println("'invalidate'\tmarks all variables as invalid, forcing reevaluation");
        this.println("eg 'x=5','y=2*x' gives value 10, 'invalidate', 'x=6', 'y' gives value 12");
    }

    public void printIntroText() {
        this.println("XJep Console");
        super.printStdHelp();
    }

    public void printOps() {
        this.println("Known operators");
        Operator[] ops = this.j.getOperatorSet().getOperators();
        int maxPrec = -1;
        int i = 0;
        while (i < ops.length) {
            if (((XOperator)ops[i]).getPrecedence() > maxPrec) {
                maxPrec = ((XOperator)ops[i]).getPrecedence();
            }
            ++i;
        }
        int jj = -1;
        while (jj <= maxPrec) {
            int i2 = 0;
            while (i2 < ops.length) {
                if (((XOperator)ops[i2]).getPrecedence() == jj) {
                    this.println(((XOperator)ops[i2]).toFullString());
                }
                ++i2;
            }
            ++jj;
        }
    }

    public boolean testSpecialCommands(String command) {
        if (!super.testSpecialCommands(command)) {
            return false;
        }
        XJep xj = (XJep)this.j;
        if (command.equals("invalidate")) {
            this.resetVars();
            return false;
        }
        if (command.startsWith("setMaxLen")) {
            String[] words = this.split(command);
            int len = Integer.parseInt(words[1]);
            xj.getPrintVisitor().setMaxLen(len);
            return false;
        }
        if (command.startsWith("setDp")) {
            String[] words = this.split(command);
            int dp = Integer.parseInt(words[1]);
            this.format = NumberFormat.getInstance();
            xj.getPrintVisitor().setNumberFormat(this.format);
            this.format.setMaximumFractionDigits(dp);
            this.format.setMinimumFractionDigits(dp);
            return false;
        }
        if (command.startsWith("setFullBrackets")) {
            String[] words = this.split(command);
            if (words.length > 1 && words[1].equals("true")) {
                xj.getPrintVisitor().setMode(1, true);
            } else {
                xj.getPrintVisitor().setMode(1, true);
            }
            return false;
        }
        if (command.startsWith("setComplexI")) {
            String[] words = this.split(command);
            if (words.length > 1 && words[1].equals("true")) {
                xj.getPrintVisitor().setMode(2, true);
            } else {
                xj.getPrintVisitor().setMode(2, true);
            }
            return false;
        }
        if (command.startsWith("verbose")) {
            String[] words = this.split(command);
            if (words.length < 2) {
                this.println("verbose should be on or off");
            } else if (words[1].equals("on")) {
                this.verbose = true;
            } else if (words[1].equals("off")) {
                this.verbose = true;
            } else {
                this.println("verbose should be on or off");
            }
            return false;
        }
        return true;
    }

    public void processEquation(Node node) throws ParseException {
        Node processed;
        XJep xj = (XJep)this.j;
        if (xj.getPrintVisitor().getMode(1)) {
            this.print("Node:\t");
            xj.println(node);
        }
        if ((processed = xj.preprocess(node)) == null) {
            return;
        }
        if (xj.getPrintVisitor().getMode(1)) {
            this.print("Processed:\t");
            xj.println(processed);
        }
        Node simp = xj.simplify(processed);
        this.print("Simplified:\t");
        this.println(xj.toString(simp));
        Object val = xj.evaluate(simp);
        String s = xj.getPrintVisitor().formatValue(val);
        this.println("Value:\t\t" + s);
    }

    public void printVars() {
        PrintVisitor pv = ((XJep)this.j).getPrintVisitor();
        SymbolTable st = this.j.getSymbolTable();
        pv.setMode(16, !this.verbose);
        this.println("Variables:");
        Enumeration loop = st.keys();
        while (loop.hasMoreElements()) {
            String s = (String)loop.nextElement();
            XVariable var = (XVariable)st.getVar(s);
            this.println("\t" + var.toString(pv));
        }
        pv.setMode(16, true);
    }

    public void resetVars() {
        this.j.getSymbolTable().clearValues();
    }
}

